/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.util;

import ch.javasoft.bitset.BitSetFactory;
import ch.javasoft.bitset.IBitSet;
import ch.javasoft.bitset.LongBitSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BitSetUtil {
    public static BitSetFactory factory() {
        return LongBitSet.FACTORY;
    }

    public static int longSize(int bitCapacity) {
        return (bitCapacity - 1) / 64 + 1;
    }

    public static int byteSize(int bitCapacity) {
        return (bitCapacity - 1) / 8 + 1;
    }

    public static long[] toLongArray(IBitSet bitSet) {
        return LongBitSet.FACTORY.convert(bitSet).toLongArray();
    }

    public static IBitSet fromLongArray(long[] longs, boolean cloneArray) {
        return BitSetUtil.factory().convert(new LongBitSet(longs, cloneArray));
    }

    public static IBitSet readFrom(DataInput in, int bitCapacity) throws IOException {
        long[] longs = new long[BitSetUtil.longSize(bitCapacity)];
        int byteSize = BitSetUtil.byteSize(bitCapacity);
        int i = 0;
        while (i < byteSize) {
            byte bt = in.readByte();
            long lg = 0xFFL & (long)bt;
            int n = i / 8;
            longs[n] = longs[n] | lg << 8 * (i % 8);
            ++i;
        }
        return BitSetUtil.fromLongArray(longs, false);
    }

    public static void writeTo(IBitSet bitSet, int bitCapacity, DataOutput out) throws IOException {
        long[] longs = BitSetUtil.toLongArray(bitSet);
        int byteSize = BitSetUtil.byteSize(bitCapacity);
        int i = 0;
        while (i < byteSize) {
            int index = i / 8;
            long lVal = index < longs.length ? longs[index] : 0L;
            byte bVal = (byte)(0xFFL & lVal >>> 8 * (i % 8));
            out.writeByte(bVal);
            ++i;
        }
    }

    public static String toHexString(IBitSet bitSet, int bitSetSize) {
        int bytes = 1 + bitSetSize / 8;
        StringBuilder sb = new StringBuilder(bytes + 8);
        long[] lArray = BitSetUtil.toLongArray(bitSet);
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            sb.append(Long.toHexString(l));
            ++n2;
        }
        sb.setLength(bytes);
        return sb.toString();
    }

    private BitSetUtil() {
    }
}

