/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.outcore;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentBitPatternTree;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentInterNode;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentLeafNode;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentNode;

public class PersistentNodeEntity {
    public final IBitSet unionPattern;
    public final int valueA;
    public final int valueB;

    public PersistentNodeEntity(IBitSet unionPattern, int valueA, int valueB) {
        this.unionPattern = unionPattern;
        this.valueA = valueA;
        this.valueB = valueB;
    }

    public static PersistentNodeEntity createForLeaf(IBitSet unionPattern, int start, int end) {
        return new PersistentNodeEntity(unionPattern, start | Integer.MIN_VALUE, end | Integer.MIN_VALUE);
    }

    public static PersistentNodeEntity createForInterNode(IBitSet unionPattern, int leftTableIndex, int rightTableIndex) {
        return new PersistentNodeEntity(unionPattern, leftTableIndex, rightTableIndex);
    }

    public boolean isLeaf() {
        return this.valueA < 0;
    }

    public PersistentLeafNode toLeafNode(PersistentBitPatternTree tree) {
        if (!this.isLeaf()) {
            throw new IllegalStateException("not a leaf node entity");
        }
        return new PersistentLeafNode(this.unionPattern, this.valueA ^ Integer.MIN_VALUE, this.valueB ^ Integer.MIN_VALUE);
    }

    public PersistentInterNode toInterNode(PersistentBitPatternTree tree, PersistentNode leftNode, PersistentNode rightNode) {
        if (this.isLeaf()) {
            throw new IllegalStateException("not a intermediate node entity");
        }
        return new PersistentInterNode(tree, this.unionPattern, this.valueA, this.valueB, leftNode, rightNode);
    }

    public PersistentNode toNode(PersistentBitPatternTree tree, PersistentNode leftNode, PersistentNode rightNode) {
        return this.isLeaf() ? this.toLeafNode(tree) : this.toInterNode(tree, leftNode, rightNode);
    }
}

