/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.incore;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.tree.BitPatternTree;
import ch.javasoft.metabolic.efm.tree.Node;
import ch.javasoft.metabolic.efm.tree.Partition;
import ch.javasoft.metabolic.efm.tree.incore.InCoreNode;
import ch.javasoft.metabolic.efm.tree.incore.IncoreInterNode;
import ch.javasoft.metabolic.efm.tree.incore.IncoreLeafNode;
import ch.javasoft.metabolic.efm.util.ColumnUtil;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncoreBitPatternTree
implements BitPatternTree {
    private final BitPatternTree.Kind kind;
    private final int bitSetSize;
    private final InCoreNode root;
    private static final int MAX_LEAF_SIZE = 4;

    public <Col extends Column, N extends Number> IncoreBitPatternTree(Thread owner, ColumnHome<N, Col> columnHome, EfmModel efmModel, AdjEnumModel<Col> itModel, BitPatternTree.Kind kind, int[] selectiveBits, SortableMemory<Col> columns) throws IOException {
        this.kind = kind;
        this.bitSetSize = itModel.getCurrentState().getBooleanSize();
        int cols = columns.getColumnCount();
        Partition partition = ColumnUtil.partitionColumns(columns, selectiveBits[0], 0, cols);
        this.root = this.createNode(columnHome, selectiveBits, 0, columns, 0, cols, partition);
    }

    @Override
    public BitPatternTree.Kind kind() {
        return this.kind;
    }

    @Override
    public int bitSetSize() {
        return this.bitSetSize;
    }

    @Override
    public Node root() {
        return this.root;
    }

    @Override
    public void closeForCurrentThread() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    private <Col extends Column, N extends Number> InCoreNode createNode(ColumnHome<N, Col> columnHome, int[] selectiveBits, int curSelectiveBit, SortableMemory<Col> columns, int start, int end, Partition lastPartition) throws IOException {
        if (end - start <= 4) {
            return this.createLeafNode(columnHome, selectiveBits, curSelectiveBit, columns, start, end, lastPartition);
        }
        return this.createInterNode(columnHome, selectiveBits, curSelectiveBit, columns, start, end, lastPartition);
    }

    protected <Col extends Column, N extends Number> IncoreInterNode createInterNode(ColumnHome<N, Col> columnHome, int[] selectiveBits, int curSelectiveBit, SortableMemory<Col> columns, int start, int end, Partition lastPartition) throws IOException {
        while (lastPartition.getMedian() == start || lastPartition.getMedian() == end) {
            lastPartition = ColumnUtil.partitionColumns(columns, selectiveBits[++curSelectiveBit], start, end);
        }
        IBitSet union = lastPartition.unionPattern();
        int median = lastPartition.getMedian();
        Partition partitionLeft = ColumnUtil.partitionColumns(columns, selectiveBits[++curSelectiveBit], start, median);
        Partition partitionRight = ColumnUtil.partitionColumns(columns, selectiveBits[curSelectiveBit], median, end);
        InCoreNode left = this.createNode(columnHome, selectiveBits, curSelectiveBit, columns, start, median, partitionLeft);
        InCoreNode right = this.createNode(columnHome, selectiveBits, curSelectiveBit, columns, median, end, partitionRight);
        return new IncoreInterNode(this, union, left, right);
    }

    protected <Col extends Column, N extends Number> IncoreLeafNode createLeafNode(ColumnHome<N, Col> columnHome, int[] selectiveBits, int curSelectiveBit, SortableMemory<Col> columns, int start, int end, Partition lastPartition) throws IOException {
        IBitSet union = lastPartition.unionPattern();
        return new IncoreLeafNode(union, start, end);
    }
}

