/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.impl;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.concurrent.ConcurrentToken;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.tree.BitPatternTree;
import ch.javasoft.metabolic.efm.tree.InterNode;
import ch.javasoft.metabolic.efm.tree.LeafNode;
import ch.javasoft.metabolic.efm.tree.Node;
import ch.javasoft.metabolic.efm.tree.TreeTraverser;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubtreeTraverser<T extends ConcurrentToken>
implements TreeTraverser<T> {
    private final int subTreeIndex;
    private final int bitsPerTree;
    private final int posLeftRightBits;
    private final int negLeftRightBits;
    private final TreeTraverser<T> delegate;

    public SubtreeTraverser(int subTreeLevel, int subTreeIndex, TreeTraverser<T> delegate) {
        this.subTreeIndex = subTreeIndex;
        this.bitsPerTree = subTreeLevel;
        int oneBits = -1 >>> 32 - this.bitsPerTree;
        this.posLeftRightBits = oneBits & subTreeIndex;
        this.negLeftRightBits = (oneBits << this.bitsPerTree & subTreeIndex) >>> this.bitsPerTree;
        this.delegate = delegate;
    }

    public <Col extends Column, N extends Number> void traverse(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, BitPatternTree posTree, BitPatternTree negTree) throws IOException {
        this.traverseNN(columnHome, iterationModel, token, 0, 0, true, posTree.root(), negTree.root());
    }

    public <Col extends Column, N extends Number> void traverseNN(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean meIsPos, Node me, Node other) throws IOException {
        me.traverseN(this, columnHome, iterationModel, token, myDepth, otherDepth, meIsPos, other);
    }

    private Node getChildTree(int depth, boolean isPos, InterNode node) {
        int mask = 1 << depth;
        int bits = isPos ? this.posLeftRightBits : this.negLeftRightBits;
        return (mask & bits) == 0 ? node.left() : node.right();
    }

    private boolean visitLeafChildTree(int myDepth, int otherDepth, boolean isPos) {
        int bits = isPos ? this.posLeftRightBits : this.negLeftRightBits;
        int curDepth = Math.max(myDepth, otherDepth);
        int mask = 1 << curDepth;
        int i = curDepth;
        while (i < this.bitsPerTree) {
            if ((mask & bits) != 0) {
                return false;
            }
            mask <<= 1;
            ++i;
        }
        return true;
    }

    public <Col extends Column, N extends Number> void traverseIN(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean meIsPos, InterNode me, Node other) throws IOException {
        other.traverseI(this, columnHome, iterationModel, token, otherDepth, myDepth, !meIsPos, me);
    }

    public <Col extends Column, N extends Number> void traverseLN(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean meIsPos, LeafNode me, Node other) throws IOException {
        other.traverseL(this, columnHome, iterationModel, token, otherDepth, myDepth, !meIsPos, me);
    }

    public <Col extends Column, N extends Number> void traverseII(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean meIsPos, InterNode me, InterNode other) throws IOException {
        if (myDepth < this.bitsPerTree && otherDepth < this.bitsPerTree) {
            Node myChild = this.getChildTree(myDepth, meIsPos, me);
            Node otherChild = this.getChildTree(otherDepth, !meIsPos, other);
            this.traverseNN(columnHome, iterationModel, token, myDepth + 1, otherDepth + 1, meIsPos, myChild, otherChild);
        } else {
            this.delegate.traverseII(columnHome, iterationModel, token, myDepth, otherDepth, meIsPos, me, other);
        }
    }

    public <Col extends Column, N extends Number> void traverseIL(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean meIsPos, InterNode me, LeafNode other) throws IOException {
        if (myDepth < this.bitsPerTree && otherDepth < this.bitsPerTree) {
            if (this.visitLeafChildTree(otherDepth, myDepth, !meIsPos)) {
                Node myChild = this.getChildTree(myDepth, meIsPos, me);
                this.traverseLN(columnHome, iterationModel, token, otherDepth, myDepth + 1, !meIsPos, other, myChild);
            }
        } else {
            this.delegate.traverseIL(columnHome, iterationModel, token, myDepth, otherDepth, meIsPos, me, other);
        }
    }

    public <Col extends Column, N extends Number> void traverseLL(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean meIsPos, LeafNode me, LeafNode other) throws IOException {
        if (myDepth < this.bitsPerTree && otherDepth < this.bitsPerTree) {
            if (this.visitLeafChildTree(myDepth, otherDepth, meIsPos) && this.visitLeafChildTree(otherDepth, myDepth, !meIsPos)) {
                this.delegate.traverseLL(columnHome, iterationModel, token, myDepth, otherDepth, meIsPos, me, other);
            }
        } else {
            this.delegate.traverseLL(columnHome, iterationModel, token, myDepth, otherDepth, meIsPos, me, other);
        }
    }

    public String toString() {
        return "subtree[" + this.subTreeIndex + "/" + (1 << (this.bitsPerTree << 1)) + ": pos/neg=" + Integer.toBinaryString(this.posLeftRightBits) + "/" + Integer.toBinaryString(this.negLeftRightBits) + "]";
    }
}

