/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.impl;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.concurrent.ConcurrentToken;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.tree.AdjacencyPrecondition;
import ch.javasoft.metabolic.efm.tree.Node;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinCardinalityAdjacencyPrecondition
implements AdjacencyPrecondition<ConcurrentToken> {
    public final int requiredCardinality;

    public MinCardinalityAdjacencyPrecondition(EfmModel model) {
        this.requiredCardinality = model.getRequiredCardinality();
    }

    @Override
    public <Col extends Column, N extends Number> boolean enterIfMet(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, ConcurrentToken token, int myDepth, int otherDepth, boolean meIsPos, Node me, Node other) {
        return me.unionPattern().getAndCardinality(other.unionPattern()) >= this.requiredCardinality;
    }

    @Override
    public <Col extends Column, N extends Number> void leave(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, ConcurrentToken token, int myDepth, int otherDepth, boolean meIsPos, Node me, Node other) {
    }

    public <Col extends Column, N extends Number> IBitSet getUnionCutIfMet(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, ConcurrentToken token, boolean meIsPos, Node me, Node other) {
        if (me.unionPattern().getAndCardinality(other.unionPattern()) >= this.requiredCardinality) {
            return me.unionPattern().getAnd(other.unionPattern());
        }
        return null;
    }

    @Override
    public <Col extends Column, N extends Number> boolean isMet(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, ConcurrentToken token, int posColIndex, int negColIndex) throws IOException {
        Object posCol = iterationModel.getMemoryPos().getColumn(posColIndex);
        Object negCol = iterationModel.getMemoryNeg().getColumn(negColIndex);
        return posCol.bitValues().getAndCardinality(negCol.bitValues()) >= this.requiredCardinality;
    }
}

