/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree;

import ch.javasoft.job.Job;
import ch.javasoft.job.MultiJobExecutable;
import ch.javasoft.metabolic.efm.adj.AbstractAdjEnum;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.concurrent.ConcurrentToken;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.dist.DistributedInfo;
import ch.javasoft.metabolic.efm.dist.PartIterator;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.memory.outcore.Recovery;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.progress.IntProgressAggregator;
import ch.javasoft.metabolic.efm.progress.ProgressAggregator;
import ch.javasoft.metabolic.efm.progress.ProgressNotifiable;
import ch.javasoft.metabolic.efm.tree.AdjacencyPrecondition;
import ch.javasoft.metabolic.efm.tree.BitPatternTree;
import ch.javasoft.metabolic.efm.tree.TreePairTraverser;
import ch.javasoft.metabolic.efm.tree.impl.SubtreePairTraverser;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentBitPatternTree;
import ch.javasoft.metabolic.efm.util.ColumnUtil;
import ch.javasoft.util.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeMemAdjEnum<T extends ConcurrentToken>
extends AbstractAdjEnum {
    private static final float zeroToOneOptimum = 1.0f;

    public TreeMemAdjEnum(String name) {
        super(name);
    }

    @Override
    public <Col extends Column, N extends Number> void adjacentPairs(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel) throws IOException {
        if (itModel.getMemoryPos().getColumnCount() == 0 || itModel.getMemoryNeg().getColumnCount() == 0) {
            return;
        }
        ProgressNotifiable prog = this.getConfig().getProgressType().createProgressNotifiable(this.getConfig(), itModel);
        IntProgressAggregator progress = prog == null || this.getConfig().getProgressPartition() <= 0 ? null : new IntProgressAggregator(prog);
        Thread treeOwner = Thread.currentThread();
        Trees trees = this.createOrRecoverTrees(treeOwner, columnHome, itModel);
        TreePairTraverser<T> traverser = this.createTreeTraverser(columnHome, itModel, trees.getPosTree(), trees.getNegTree(), null);
        this.traverseTrees(columnHome, itModel, trees, traverser, progress);
        trees.getPosTree().close();
        trees.getNegTree().close();
    }

    public <Col extends Column, N extends Number> void execCentralized(ColumnHome<N, Col> columnHome, Config config, EfmModel efmModel, AdjEnumModel<Col> itModel) throws IOException {
        if (itModel.getMemoryPos().getColumnCount() > 0 && itModel.getMemoryNeg().getColumnCount() > 0) {
            this.initialize(columnHome, config, efmModel);
            this.createOrRecoverTrees(Thread.currentThread(), columnHome, itModel);
        }
    }

    public <Col extends Column, N extends Number> void execDistributed(ColumnHome<N, Col> columnHome, Config config, EfmModel efmModel, AdjEnumModel<Col> itModel, DistributedInfo distInfo, PartIterator partIterator, ProgressAggregator progress) throws IOException {
        if (itModel.getMemoryPos().getColumnCount() == 0 || itModel.getMemoryNeg().getColumnCount() == 0) {
            return;
        }
        this.initialize(columnHome, config, efmModel);
        int subTreeIndex = partIterator.getNextPart();
        if (subTreeIndex >= 0) {
            int subTreeLevel = 0;
            while (1 << (subTreeLevel << 1) < distInfo.getPartitionCount()) {
                ++subTreeLevel;
            }
            Thread treeOwner = null;
            Trees trees = this.openTrees(treeOwner, columnHome, itModel);
            do {
                TreePairTraverser<T> traverser = this.createTreeTraverser(columnHome, itModel, trees.getPosTree(), trees.getNegTree(), null);
                this.traverseTrees(columnHome, itModel, trees, new SubtreePairTraverser<T>(subTreeLevel, subTreeIndex, traverser), progress);
            } while ((subTreeIndex = partIterator.getNextPart()) >= 0);
            trees.getPosTree().closeForCurrentThread();
            trees.getNegTree().closeForCurrentThread();
        }
    }

    private <Col extends Column, N extends Number> Trees createOrRecoverTrees(Thread treeOwner, ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel) throws IOException {
        Recovery recovery = Recovery.getRecovery(this.getConfig().getFlag());
        if (recovery != null && recovery.isTreeRecovery()) {
            return this.openTrees(treeOwner, columnHome, itModel);
        }
        int[] selectiveBits = TreeMemAdjEnum.calculateBitOrder(itModel.getMemoryPos(), itModel.getMemoryNeg());
        return this.createTrees(treeOwner, columnHome, itModel, selectiveBits);
    }

    private <Col extends Column, N extends Number> Trees createTrees(Thread treeOwner, ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel, int[] selectiveBits) throws IOException {
        TreeJob treeJob = new TreeJob(this.createTreeJob(Thread.currentThread(), columnHome, itModel, BitPatternTree.Kind.Pos, selectiveBits), this.createTreeJob(Thread.currentThread(), columnHome, itModel, BitPatternTree.Kind.Neg, selectiveBits));
        return treeJob.execAndWait();
    }

    private <Col extends Column, N extends Number> Job<BitPatternTree> createTreeJob(final Thread treeOwner, final ColumnHome<N, Col> columnHome, final AdjEnumModel<Col> itModel, final BitPatternTree.Kind kind, final int[] selectiveBits) throws IOException {
        final SortableMemory<Col> mem = kind == BitPatternTree.Kind.Pos ? itModel.getMemoryPos() : itModel.getMemoryNeg();
        return new Job<BitPatternTree>(){

            @Override
            public BitPatternTree run() throws IOException {
                BitPatternTree tree = TreeMemAdjEnum.this.createTree(treeOwner, columnHome, itModel, kind, selectiveBits, mem);
                mem.close(false);
                if (treeOwner != Thread.currentThread()) {
                    tree.closeForCurrentThread();
                }
                return tree;
            }
        };
    }

    private <Col extends Column, N extends Number> Trees openTrees(Thread treeOwner, ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel) throws IOException {
        final BitPatternTree posTree = this.openTree(treeOwner, columnHome, itModel, BitPatternTree.Kind.Pos);
        final BitPatternTree negTree = this.openTree(treeOwner, columnHome, itModel, BitPatternTree.Kind.Neg);
        return new Trees(){

            @Override
            public BitPatternTree getPosTree() {
                return posTree;
            }

            @Override
            public BitPatternTree getNegTree() {
                return negTree;
            }
        };
    }

    private <Col extends Column, N extends Number> void traverseTrees(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel, Trees trees, TreePairTraverser<T> treeTraverser, ProgressAggregator progress) throws IOException {
        T token = this.createToken(columnHome, itModel, trees.getPosTree(), trees.getNegTree(), progress);
        treeTraverser.traverse(columnHome, itModel, token, trees.getPosTree(), trees.getNegTree());
        this.releaseToken(columnHome, itModel, trees.getPosTree(), trees.getNegTree(), token);
    }

    protected <Col extends Column, N extends Number> BitPatternTree openTree(Thread treeOwner, ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel, BitPatternTree.Kind kind) throws IOException {
        Recovery recovery = Recovery.getRecovery(this.getConfig().getFlag());
        File folder = recovery != null && recovery.isTreeRecovery() ? recovery.getRecoveryFolder() : this.getConfig().getTempDir().getPersonalizedDir();
        return PersistentBitPatternTree.open(treeOwner, folder, columnHome, this.getEfmModel(), itModel, kind);
    }

    protected abstract <Col extends Column, N extends Number> BitPatternTree createTree(Thread var1, ColumnHome<N, Col> var2, AdjEnumModel<Col> var3, BitPatternTree.Kind var4, int[] var5, SortableMemory<Col> var6) throws IOException;

    protected abstract <Col extends Column, N extends Number> TreePairTraverser<T> createTreeTraverser(ColumnHome<N, Col> var1, AdjEnumModel<Col> var2, BitPatternTree var3, BitPatternTree var4, AdjacencyPrecondition<T> var5) throws IOException;

    protected abstract <Col extends Column, N extends Number> T createToken(ColumnHome<N, Col> var1, AdjEnumModel<Col> var2, BitPatternTree var3, BitPatternTree var4, ProgressAggregator var5) throws IOException;

    protected abstract <Col extends Column, N extends Number> void releaseToken(ColumnHome<N, Col> var1, AdjEnumModel<Col> var2, BitPatternTree var3, BitPatternTree var4, T var5) throws IOException;

    protected static int[] calculateBitOrder(SortableMemory<? extends Column> pos, SortableMemory<? extends Column> neg) throws IOException {
        int bitCount = Math.max(ColumnUtil.getBooleanSize(pos), ColumnUtil.getBooleanSize(neg));
        int[][] cnt = new int[bitCount][3];
        int bit = 0;
        while (bit < bitCount) {
            cnt[bit][2] = bit;
            ++bit;
        }
        Random rnd = new Random();
        TreeMemAdjEnum.updateCount(pos, cnt, bitCount, rnd);
        TreeMemAdjEnum.updateCount(neg, cnt, bitCount, rnd);
        Arrays.sort(cnt, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                float diff2;
                float rel1 = (float)o1[0] / (float)o1[1];
                float rel2 = (float)o2[0] / (float)o2[1];
                float diff1 = Math.abs(rel1 - 1.0f);
                return diff1 < (diff2 = Math.abs(rel2 - 1.0f)) ? -1 : (diff1 > diff2 ? 1 : 0);
            }
        });
        int[] result = new int[bitCount];
        int ii = 0;
        while (ii < cnt.length) {
            result[ii] = cnt[ii][2];
            ++ii;
        }
        return result;
    }

    private static void updateCount(SortableMemory<? extends Column> columns, int[][] cnt, int bitCount, Random rnd) throws IOException {
        int count = columns.getColumnCount();
        int i = 0;
        while (i < 1024) {
            Object col0 = columns.getColumn(rnd.nextInt(count));
            Object col1 = columns.getColumn(rnd.nextInt(count));
            int bit = 0;
            while (bit < cnt.length) {
                if (col0.get(bit) != col1.get(bit)) {
                    int[] nArray = cnt[bit];
                    nArray[0] = nArray[0] + col0.bitValues().getXorCardinality(col1.bitValues());
                    int[] nArray2 = cnt[bit];
                    nArray2[1] = nArray2[1] + bitCount;
                } else {
                    int[] nArray = cnt[bit];
                    nArray[1] = nArray[1] + 1;
                }
                ++bit;
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeJob {
        private final MultiJobExecutable<BitPatternTree> executable;

        public TreeJob(Job<BitPatternTree> job1, Job<BitPatternTree> job2) {
            this.executable = new MultiJobExecutable<BitPatternTree>(job1, job2);
        }

        public Trees execAndWait() throws IOException {
            BitPatternTree negTree;
            BitPatternTree posTree;
            try {
                Object trees = this.executable.execAndWaitThrowException();
                if (((BitPatternTree)trees.peek()).kind() == BitPatternTree.Kind.Pos) {
                    posTree = (BitPatternTree)trees.remove();
                    negTree = (BitPatternTree)trees.remove();
                } else {
                    negTree = (BitPatternTree)trees.remove();
                    posTree = (BitPatternTree)trees.remove();
                }
            }
            catch (Throwable e) {
                throw ExceptionUtil.toRuntimeExceptionOr(IOException.class, e);
            }
            return new Trees(){

                @Override
                public BitPatternTree getPosTree() {
                    return posTree;
                }

                @Override
                public BitPatternTree getNegTree() {
                    return negTree;
                }
            };
        }
    }

    private static interface Trees {
        public BitPatternTree getPosTree();

        public BitPatternTree getNegTree();
    }
}

