/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.efm.output.CallbackGranularity;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.EfmOutputFormatter;
import ch.javasoft.metabolic.efm.output.Util;
import java.io.PrintWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatlabOutputFormatter
implements EfmOutputFormatter<PrintWriter> {
    private boolean formatAsDouble(EfmOutputCallback cb) {
        return cb.getGranularity() == CallbackGranularity.DoubleUncompressed;
    }

    protected String getVariableName() {
        return "efmout";
    }

    @Override
    public void formatHeader(EfmOutputCallback cb, PrintWriter writer, EfmOutputEvent evt) {
        MetabolicNetwork net = Util.getNetworkUncompressedIfNeeded(cb.getGranularity(), evt);
        writer.print(String.valueOf(this.getVariableName()) + ".reactions = {");
        boolean first = true;
        for (Reaction reaction : net.getReactions()) {
            if (first) {
                first = false;
            } else {
                writer.print(", ");
            }
            writer.print("'" + reaction.getFullName() + "'");
        }
        writer.println("};");
        if (this.formatAsDouble(cb)) {
            writer.println(String.valueOf(this.getVariableName()) + ".efm = sparse(0, " + net.getReactions().length() + ");");
        }
    }

    @Override
    public void formatEfmHeader(EfmOutputCallback cb, PrintWriter writer, EfmOutputEvent evt, long efmIndex) {
        if (this.formatAsDouble(cb)) {
            writer.println("% " + this.getVariableName() + ".efm(" + (efmIndex + 1L) + ",:)");
        } else {
            writer.print(String.valueOf(this.getVariableName()) + ".efm(" + (efmIndex + 1L) + ",:) = ('");
        }
    }

    @Override
    public void formatEfmValue(EfmOutputCallback cb, PrintWriter writer, EfmOutputEvent evt, long efmIndex, int valueIndex, Number value) {
        double dvalue = value.doubleValue();
        if (this.formatAsDouble(cb)) {
            if (dvalue != 0.0) {
                writer.print(String.valueOf(this.getVariableName()) + ".efm(" + (efmIndex + 1L) + ", " + (valueIndex + 1) + ")=");
                writer.print(value);
                writer.print("; ");
            }
        } else {
            writer.print(dvalue == 0.0 ? (char)'0' : '1');
        }
    }

    @Override
    public void formatEfmFooter(EfmOutputCallback cb, PrintWriter writer, EfmOutputEvent evt, long efmIndex) {
        if (this.formatAsDouble(cb)) {
            writer.println();
        } else {
            writer.println("' == '1');");
        }
    }

    @Override
    public void formatFooter(EfmOutputCallback cb, PrintWriter writer, EfmOutputEvent evt, long countEfms) {
        writer.println("% " + countEfms + " elementary modes.");
    }

    @Override
    public boolean isEfmValueIterationNeeded(EfmOutputCallback cb) {
        return true;
    }
}

