/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model.canonical;

import ch.javasoft.math.BigFraction;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifier;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifierFactory;
import ch.javasoft.metabolic.efm.model.EfmModelFactory;
import ch.javasoft.metabolic.efm.model.canonical.CanonicalBigIntegerColumnInspectorModifier;
import ch.javasoft.metabolic.efm.model.canonical.CanonicalDoubleColumnInspectorModifier;
import ch.javasoft.metabolic.efm.model.canonical.CanonicalEfmModel;
import ch.javasoft.metabolic.efm.model.canonical.CanonicalFractionalColumnInspectorModifier;
import ch.javasoft.metabolic.efm.util.DualKey;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalEfmModelFactory
implements EfmModelFactory,
ColumnInspectorModifierFactory {
    private final Map<DualKey, ColumnInspectorModifier<?, ?>> columnInspectorsModifiers = new HashMap();

    public CanonicalEfmModelFactory() {
        this.columnInspectorsModifiers.put(new DualKey(Double.class, double[].class), new CanonicalDoubleColumnInspectorModifier());
        this.columnInspectorsModifiers.put(new DualKey(BigFraction.class, BigFraction[].class), new CanonicalFractionalColumnInspectorModifier());
        this.columnInspectorsModifiers.put(new DualKey(BigInteger.class, BigInteger[].class), new CanonicalBigIntegerColumnInspectorModifier());
    }

    @Override
    public <N extends Number, Col extends Column> CanonicalEfmModel createEfmModel(ColumnHome<N, Col> columnHome, Config config, MetabolicNetwork network) {
        return new CanonicalEfmModel(columnHome, network, config, (ColumnInspectorModifierFactory)this);
    }

    @Override
    public <N extends Number, A> ColumnInspectorModifier<N, A> getColumnInspectorModifier(Class<N> numericType, Class<A> numericArrayType) {
        ColumnInspectorModifier<?, ?> insMod = this.columnInspectorsModifiers.get(new DualKey(numericType, numericArrayType));
        if (insMod == null) {
            throw new IllegalArgumentException("no modifier for canonical model and numeric/array type " + numericType.getSimpleName() + "/" + numericArrayType.getSimpleName());
        }
        return insMod;
    }
}

