/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model.canonical;

import ch.javasoft.math.NumberOperations;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.AppendableMemory;
import ch.javasoft.metabolic.efm.memory.MemoryFactory;
import ch.javasoft.metabolic.efm.memory.ReadWriteMemory;
import ch.javasoft.metabolic.efm.model.AbstractNetworkEfmModel;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifierFactory;
import ch.javasoft.metabolic.efm.model.ColumnToFluxDistributionConverter;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.metabolic.efm.model.canonical.CanonicalColumnToFluxDistributionConverter;
import ch.javasoft.metabolic.efm.model.canonical.LogPkg;
import ch.javasoft.metabolic.efm.sort.SortUtil;
import ch.javasoft.metabolic.efm.util.ReactionMapping;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.smx.impl.DefaultIntMatrix;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.smx.ops.Mul;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.IntArray;
import ch.javasoft.util.logging.LogWriter;
import java.io.IOException;
import java.util.BitSet;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalEfmModel
extends AbstractNetworkEfmModel {
    private final ReadableMatrix inverseMatrix;

    private boolean isNoSplit(MetabolicNetwork net, int col) {
        return this.getReactionMapping().getReactionCategoryBySortedIndex(col) == ReactionMapping.Category.NoSplit;
    }

    /*
     * Unable to fully structure code
     */
    public <N extends Number> CanonicalEfmModel(ColumnHome<N, ?> columnHome, MetabolicNetwork net, Config config, ColumnInspectorModifierFactory factory) {
        block18: {
            block17: {
                super(columnHome, net, config, factory);
                stoich = this.getStoichRational();
                rows = stoich.getRowCount();
                cols = stoich.getColumnCount();
                nosplit = this.getConfig().getReactionsNoSplit().size();
                if (nosplit != 0) break block17;
                this.inverseMatrix = DefaultIntMatrix.identity(cols);
                break block18;
            }
            rmap = this.getReactionSorting();
            len = cols;
            ind = 0;
            while (ind < len) {
                if (rmap[ind] == ind && rmap[len - 1] == len - 1) ** GOTO lbl17
                throw new RuntimeException("expected identity reaction sorting with map[i] = i, but found " + java.util.Arrays.toString(rmap));
lbl-1000:
                // 1 sources

                {
                    ++ind;
lbl17:
                    // 2 sources

                    ** while (!this.isNoSplit((MetabolicNetwork)net, (int)ind))
                }
lbl18:
                // 2 sources

                while (this.isNoSplit(net, len - 1)) {
                    --len;
                }
                if (ind >= len) continue;
                IntArray.swap(rmap, ind, len - 1);
                ++ind;
                --len;
            }
            idLen = cols - nosplit;
            mxD = new DefaultBigIntegerRationalMatrix(rows, nosplit);
            row = 0;
            while (row < rows) {
                col = 0;
                while (col < nosplit) {
                    mxD.setValueAt(row, col, stoich.getNumberValueAt(row, rmap[col + idLen]));
                    ++col;
                }
                ++row;
            }
            mxD.reduce();
            ptrRowmap = new int[1][];
            ptrColmap = new int[1][];
            mxInvD = Gauss.getRationalInstance().invertMaximalSubmatrix(mxD, (int[][])ptrRowmap, (int[][])ptrColmap);
            if (mxInvD.getRowCount() < nosplit) {
                throw new RuntimeException("matrix has not full rank, expected " + nosplit + " but found " + mxInvD.getRowCount());
            }
            rmapOrig = Arrays.copyOfRange(rmap, idLen, rmap.length);
            i = idLen;
            while (i < cols) {
                rmap[i] = rmapOrig[ptrColmap[0][i - idLen]];
                ++i;
            }
            mxNegC = new DefaultBigIntegerRationalMatrix(nosplit, idLen);
            usedRows = new BitSet(rows);
            irow = 0;
            while (irow < rows) {
                if (this.getMetaboliteSorting()[irow] != irow) {
                    throw new RuntimeException("expected identity metabolite sorting with map[i] = i, but found " + java.util.Arrays.toString(this.getMetaboliteSorting()));
                }
                if (irow < nosplit) {
                    row = ptrRowmap[0][irow];
                    icol = 0;
                    while (icol < idLen) {
                        col = rmap[icol];
                        mxNegC.setValueAt(irow, icol, stoich.getNumberValueAt(row, col).negate());
                        ++icol;
                    }
                } else {
                    row = usedRows.nextClearBit(0);
                }
                usedRows.set(row);
                this.getMetaboliteSorting()[irow] = row;
                ++irow;
            }
            mxNegC.reduce();
            mxInvDxNegC = (BigIntegerRationalMatrix)Mul.multiplyGeneric(mxInvD, mxNegC);
            mxInvA2 = new DefaultBigIntegerRationalMatrix(cols, cols);
            i = 0;
            while (i < idLen) {
                mxInvA2.setValueAt(i, i, 1);
                ++i;
            }
            row = idLen;
            while (row < cols) {
                col = 0;
                while (col < idLen) {
                    mxInvA2.setValueAt(row, col, mxInvDxNegC.getBigFractionValueAt(row - idLen, col));
                    ++col;
                }
                col = idLen;
                while (col < cols) {
                    mxInvA2.setValueAt(row, col, mxInvD.getBigFractionValueAt(row - idLen, col - idLen));
                    ++col;
                }
                ++row;
            }
            this.inverseMatrix = stoich instanceof BigIntegerRationalMatrix != false ? mxInvA2 : mxInvA2.toDoubleMatrix(false);
            this.getReactionMapping().refreshSortMapping();
        }
        LogPkg.LOGGER.info("initial inverse matrix has dimensions " + this.inverseMatrix.getRowCount() + "x" + this.inverseMatrix.getColumnCount());
        if (LogPkg.LOGGER.isLoggable(Level.FINER)) {
            lw = new LogWriter(LogPkg.LOGGER, Level.FINER);
            LogPkg.LOGGER.info("initial inverse matrix:");
            this.inverseMatrix.writeToMultiline(lw);
            lw.close();
        }
        SortUtil.sortStoich(new DefaultBigIntegerRationalMatrix(stoich), nosplit, this.getMetaboliteSorting(), net, config);
        this.getReactionMapping().refreshSortMapping();
    }

    @Override
    public <N extends Number, Col extends Column> ColumnToFluxDistributionConverter<N, Col> getColumnToFluxDistributionConverter(ColumnHome<N, Col> columnHome) {
        return new CanonicalColumnToFluxDistributionConverter<N, Col>(columnHome);
    }

    @Override
    public <N extends Number, Col extends Column> AppendableMemory<Col> createInitialMemory(ColumnHome<N, Col> columnHome, MemoryFactory memoryFactory) throws IOException {
        ReadableMatrix<N> stoich = this.getStoichiometricMatrix(columnHome);
        ReadableMatrix<N> invert = columnHome.castMatrix(this.inverseMatrix);
        NumberOperations nops = stoich.getNumberOperations();
        int cols = stoich.getColumnCount();
        int nosplit = this.getConfig().getReactionsNoSplit().size();
        int idLen = cols - nosplit;
        Column[] columns = columnHome.newInstances(columnHome.castMatrix(this.inverseMatrix), this.getBooleanSize(0));
        int col = 0;
        while (col < cols) {
            int cntNonZeros = 0;
            int row = 0;
            while (row < idLen) {
                boolean isZero = row != col;
                columns[col].bitValues().set(row, isZero);
                if (!isZero) {
                    ++cntNonZeros;
                }
                ++row;
            }
            row = idLen;
            while (row < cols) {
                int stoichRow = this.getMetaboliteSorting()[row - idLen];
                Object sum = nops.zero();
                int k = 0;
                while (k < cols) {
                    int stoichCol = this.getReactionSorting()[k];
                    N valA = stoich.getNumberValueAt(stoichRow, stoichCol);
                    N valB = invert.getNumberValueAt(k, col);
                    sum = nops.add(sum, nops.multiply(valA, valB));
                    sum = nops.reduce(sum);
                    ++k;
                }
                boolean isZero = this.zero().isZero(((Number)sum).doubleValue());
                columns[col].bitValues().set(row, isZero);
                if (!isZero) {
                    ++cntNonZeros;
                }
                ++row;
            }
            if (cntNonZeros != 1) {
                throw new RuntimeException("column should have a single non-zero entry in the boolean part: " + columns[col]);
            }
            ++col;
        }
        ReadWriteMemory<Column> memory = memoryFactory.createReadWriteMemory(columnHome, this, 1, null);
        memory.appendColumns(java.util.Arrays.asList(columns));
        return memory;
    }

    @Override
    public boolean cutOff(NetworkEfmModel.Partition partition) {
        return !NetworkEfmModel.Partition.Zero.equals((Object)partition);
    }

    @Override
    public int getHyperplaneIndex(int iteration) {
        int[] sort = this.getMetaboliteSorting();
        return iteration == 0 || iteration > sort.length ? -1 : sort[iteration - 1];
    }

    @Override
    public int getIterationCount() {
        return this.getStoichRational().getRowCount();
    }

    @Override
    public int getBooleanSize(int iteration) {
        return this.getFinalBooleanSize();
    }

    @Override
    public int getNumericSize(int iteration) {
        return this.getFinalNumericSize();
    }

    @Override
    public int getFinalBooleanSize() {
        return this.getStoichRational().getColumnCount();
    }

    @Override
    public int getFinalNumericSize() {
        return this.getStoichRational().getColumnCount();
    }
}

