/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model;

import ch.javasoft.metabolic.efm.model.DefaultIterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import java.io.IOException;

public class DefaultIterationStepModel
implements IterationStepModel {
    private final int iterationIndex;
    private final IterationStateModel currentState;
    private final IterationStateModel nextState;

    public DefaultIterationStepModel(NetworkEfmModel efmModel, int iteration) {
        this(iteration, new DefaultIterationStateModel(efmModel, iteration), new DefaultIterationStateModel(efmModel, iteration + 1));
    }

    public static DefaultIterationStepModel getFinal(NetworkEfmModel efmModel) {
        return new DefaultIterationStepModel(efmModel.getIterationCount() + 1, new DefaultIterationStateModel(efmModel, efmModel.getIterationCount() + 1), DefaultIterationStateModel.getFinal(efmModel));
    }

    protected DefaultIterationStepModel(IterationStepModel model) {
        this(model.getIterationIndex(), model.getCurrentState(), model.getNextState());
    }

    protected DefaultIterationStepModel(int iterationIndex, IterationStateModel current, IterationStateModel next) {
        this.iterationIndex = iterationIndex;
        this.currentState = current;
        this.nextState = next;
    }

    public int getIterationIndex() {
        return this.iterationIndex;
    }

    public IterationStateModel getCurrentState() {
        return this.currentState;
    }

    public IterationStateModel getNextState() {
        return this.nextState;
    }

    public void closeForThread() throws IOException {
    }

    public String toString() {
        return "IterationStep[it=" + this.iterationIndex + "]:" + this.currentState + "-->" + this.nextState;
    }
}

