/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.memory.outcore;

import ch.javasoft.jbase.Table;
import ch.javasoft.jbase.util.CachedTableWeakReference;
import ch.javasoft.jbase.util.Tables;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.memory.IndexableMemory;
import ch.javasoft.metabolic.efm.memory.MappedSortableMemory;
import ch.javasoft.metabolic.efm.memory.MemoryPart;
import ch.javasoft.metabolic.efm.memory.ReadWriteMemory;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutOfCoreMemory<Col extends Column>
implements ReadWriteMemory<Col> {
    public final boolean mSortInCore;
    public final File mFile;
    public final int mBooleanSize;
    public final int mNumericSize;
    public final int mIteration;
    private final ColumnHome<?, Col> mColumnHome;
    private final Table<Col> mTable;

    public OutOfCoreMemory(String fileId) throws IOException {
        this(new FileId(fileId));
    }

    public OutOfCoreMemory(FileId<Col> fileId) throws IOException {
        if (!fileId.getFile().exists() || !fileId.getFile().canRead()) {
            throw new IOException("cannot read file: " + fileId.getFile().getAbsolutePath());
        }
        this.mFile = fileId.getFile();
        this.mBooleanSize = fileId.getBooleanSize();
        this.mNumericSize = fileId.getNumericSize();
        this.mIteration = fileId.getIteration();
        this.mColumnHome = fileId.getColumnHome();
        this.mSortInCore = fileId.sortInCore();
        this.mTable = OutOfCoreMemory.getNestedTable(this.mColumnHome.openTable(fileId.getFolder(), fileId.getFileName(), this.mBooleanSize, this.mNumericSize));
    }

    public OutOfCoreMemory(File folder, int iteration, int booleanSize, int numericSize, boolean sortInCore, ColumnHome<?, Col> columnHome) throws IOException {
        this(folder, FileName.NORMAL, iteration, booleanSize, numericSize, sortInCore, columnHome);
    }

    public OutOfCoreMemory(File folder, MemoryPart part, int iteration, int booleanSize, int numericSize, boolean sortInCore, ColumnHome<?, Col> columnHome) throws IOException {
        this(folder, FileName.getPartFileName(part), iteration, booleanSize, numericSize, sortInCore, columnHome);
    }

    private OutOfCoreMemory(File folder, FileName fileName, int iteration, int booleanSize, int numericSize, boolean sortInCore, ColumnHome<?, Col> columnHome) throws IOException {
        this(folder, fileName.getFileName(iteration), iteration, booleanSize, numericSize, sortInCore, columnHome);
    }

    private OutOfCoreMemory(File folder, String fileName, int iteration, int booleanSize, int numericSize, boolean sortInCore, ColumnHome<?, Col> columnHome) throws IOException {
        if (!folder.exists()) {
            throw new IOException("no such folder: " + folder.getAbsolutePath());
        }
        this.mFile = new File(folder, fileName);
        this.mBooleanSize = booleanSize;
        this.mNumericSize = numericSize;
        this.mIteration = iteration;
        this.mColumnHome = columnHome;
        this.mSortInCore = sortInCore;
        this.mTable = OutOfCoreMemory.getNestedTable(columnHome.createTable(folder, fileName, booleanSize, numericSize));
    }

    private static <C extends Column> Table<C> getNestedTable(Table<C> table) throws IOException {
        return new CachedTableWeakReference<C>(table);
    }

    @Override
    public String fileId() throws IOException {
        return FileId.toString(this);
    }

    @Override
    public void appendColumn(Col column) throws IOException {
        this.mTable.add(column);
    }

    @Override
    public void appendColumns(Iterable<? extends Col> columns) throws IOException {
        for (Column col : columns) {
            this.appendColumn(col);
        }
    }

    @Override
    public void appendFrom(IndexableMemory<? extends Col> memory) throws IOException {
        int i = 0;
        while (i < memory.getColumnCount()) {
            Col col = memory.getColumn(i);
            this.appendColumn(col);
            ++i;
        }
    }

    @Override
    public void swapColumns(int indexA, int indexB) throws IOException {
        this.mTable.swap(indexA, indexB);
    }

    public void clear() throws IOException {
        this.mTable.removeAll();
    }

    @Override
    public Col getColumn(int index) throws IOException {
        return (Col)((Column)this.mTable.get(index));
    }

    @Override
    public int getColumnCount() throws IOException {
        return this.mTable.size();
    }

    @Override
    public Iterator<Col> iterator() {
        return Collections.unmodifiableList(Tables.asList(this.mTable)).iterator();
    }

    @Override
    public SortableMemory<Col> toSortableMemory() throws IOException {
        return this.mSortInCore ? new MappedSortableMemory(this) : this;
    }

    @Override
    public void flush() throws IOException {
        this.mTable.flush();
    }

    @Override
    public void close(boolean erase) throws IOException {
        this.mTable.close(erase);
    }

    protected void finalize() throws Throwable {
        this.close(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileId<Col extends Column> {
        final String[] fileIdParts;

        FileId(String fileId) {
            this.fileIdParts = fileId.split(":");
        }

        public ColumnHome<?, Col> getColumnHome() {
            return Arithmetic.parse(Parts.Arithmetic.getPart(this.fileIdParts)).getColumnHome();
        }

        public int getNumericSize() {
            return Integer.parseInt(Parts.NumericSize.getPart(this.fileIdParts));
        }

        public int getBooleanSize() {
            return Integer.parseInt(Parts.BooleanSize.getPart(this.fileIdParts));
        }

        public int getIteration() {
            return Integer.parseInt(Parts.Iteration.getPart(this.fileIdParts));
        }

        public File getFile() {
            return new File(Parts.FileName.getPart(this.fileIdParts));
        }

        public boolean sortInCore() {
            try {
                return Boolean.parseBoolean(Parts.SortInCore.getPart(this.fileIdParts));
            }
            catch (Exception e) {
                return true;
            }
        }

        public File getFolder() {
            return this.getFile().getParentFile();
        }

        public String getFileName() {
            return this.getFile().getName();
        }

        static String toString(OutOfCoreMemory mem) {
            return FileId.toString(mem.mColumnHome.getArithmetic(), mem.mNumericSize, mem.mBooleanSize, mem.mIteration, mem.mFile, mem.mSortInCore);
        }

        static String toString(Arithmetic arith, int numericSize, int booleanSize, int iteration, File file, boolean sortInCore) {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)arith).append(':').append(numericSize).append(':').append(booleanSize).append(':').append(iteration).append(':').append(file.getAbsolutePath()).append(':').append(sortInCore);
            return sb.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Parts {
            Arithmetic,
            NumericSize,
            BooleanSize,
            Iteration,
            FileName,
            SortInCore;


            public String getPart(String[] parts) {
                return parts[this.ordinal()];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileName {
        public static final FileName NORMAL = new FileName("cols_", "i.tbl");
        private final String prefix;
        private final String postfix;

        public static FileName getPartFileName(MemoryPart part) {
            return new FileName("cols_part_" + part.getPartId() + "_", "i.tbl");
        }

        private FileName(String prefix, String postFix) {
            this.prefix = prefix;
            this.postfix = postFix;
        }

        public String getFileName(int iteration) {
            return String.valueOf(this.prefix) + iteration + this.postfix;
        }

        public <N extends Number, Col extends Column> FileId<Col> getFileId(ColumnHome<N, Col> columnHome, File dataFolder, int iteration, int numericSize, int booleanSize, boolean sortInCore) {
            return new FileId(FileId.toString(columnHome.getArithmetic(), numericSize, booleanSize, iteration, new File(dataFolder, this.getFileName(iteration)), sortInCore));
        }

        public int getIteration(String fileName) {
            if (fileName.length() <= this.prefix.length() + this.postfix.length()) {
                return -1;
            }
            if (!fileName.startsWith(this.prefix)) {
                return -1;
            }
            if (!fileName.endsWith(this.postfix)) {
                return -1;
            }
            String strIt = fileName.substring(this.prefix.length(), fileName.length() - this.postfix.length());
            try {
                return Integer.parseInt(strIt);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
    }
}

