/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.config;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.varint.VarIntNumber;
import ch.javasoft.metabolic.efm.column.BigIntegerColumn;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.column.DoubleColumn;
import ch.javasoft.metabolic.efm.column.FractionalColumn;
import ch.javasoft.metabolic.efm.column.RawBigIntegerColumn;
import ch.javasoft.metabolic.efm.column.VarIntColumn;
import ch.javasoft.util.numeric.Zero;
import ch.javasoft.xml.config.XmlConfigException;
import java.math.BigInteger;
import java.util.Arrays;
import org.dom4j.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Arithmetic {
    double_{

        public ColumnHome<Double, DoubleColumn> getColumnHome() {
            return DoubleColumn.HOME;
        }

        @Override
        public Zero getDefaultZero() {
            return new Zero();
        }

        @Override
        public boolean isExact() {
            return false;
        }
    }
    ,
    fractional{

        public ColumnHome<BigFraction, FractionalColumn> getColumnHome() {
            return FractionalColumn.HOME;
        }

        @Override
        public Zero getDefaultZero() {
            return new Zero(0.0);
        }

        @Override
        public boolean isExact() {
            return true;
        }
    }
    ,
    bigint{

        public ColumnHome<BigInteger, BigIntegerColumn> getColumnHome() {
            return BigIntegerColumn.HOME;
        }

        @Override
        public Zero getDefaultZero() {
            return new Zero(0.0);
        }

        @Override
        public boolean isExact() {
            return true;
        }
    }
    ,
    rawint{

        public ColumnHome<BigInteger, RawBigIntegerColumn> getColumnHome() {
            return RawBigIntegerColumn.HOME;
        }

        @Override
        public Zero getDefaultZero() {
            return new Zero(0.0);
        }

        @Override
        public boolean isExact() {
            return true;
        }
    }
    ,
    varint{

        public ColumnHome<VarIntNumber, VarIntColumn> getColumnHome() {
            return VarIntColumn.HOME;
        }

        @Override
        public Zero getDefaultZero() {
            return new Zero(0.0);
        }

        @Override
        public boolean isExact() {
            return true;
        }
    };


    private Arithmetic() {
    }

    public static Arithmetic parse(String name) throws IllegalArgumentException {
        try {
            return Arithmetic.valueOf(name.toLowerCase());
        }
        catch (IllegalArgumentException ex) {
            try {
                return Arithmetic.valueOf(String.valueOf(name.toLowerCase()) + "_");
            }
            catch (IllegalArgumentException ex2) {
                throw new IllegalArgumentException("invalid value for arithmetic, expected " + Arrays.toString((Object[])Arithmetic.values()) + ", but found: " + name);
            }
        }
    }

    public static Arithmetic parse(Attribute attribute) throws XmlConfigException {
        try {
            return Arithmetic.parse(attribute.getValue());
        }
        catch (IllegalArgumentException ex) {
            throw new XmlConfigException(ex.getLocalizedMessage(), attribute);
        }
    }

    public String getNiceName() {
        String name = this.name();
        return name.endsWith("_") ? name.substring(0, name.length() - 1) : name;
    }

    public String toString() {
        return this.getNiceName();
    }

    public NumberOperations<?> getNumberOperations() {
        return this.getColumnHome().getNumberOperations();
    }

    public abstract boolean isExact();

    public abstract ColumnHome<?, ?> getColumnHome();

    public abstract Zero getDefaultZero();

    /* synthetic */ Arithmetic(String string, int n, Arithmetic arithmetic) {
        this();
    }
}

