/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.concurrent;

import ch.javasoft.metabolic.efm.concurrent.ConcurrentToken;
import ch.javasoft.metabolic.efm.concurrent.ReleasePolicy;
import ch.javasoft.metabolic.efm.config.Config;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;

public class WaitForHalfReleasePolicy
implements ReleasePolicy {
    private final Semaphore threadBarrierOwner = new Semaphore(1);
    private volatile int memberCount;
    private volatile Semaphore threadBarrierMember;
    private volatile CountDownLatch threadBarrier;

    public void initialize(Config config, int jobs, int threads) {
        this.memberCount = (threads + 1) / 2;
        this.threadBarrierMember = new Semaphore(this.memberCount);
        this.threadBarrier = new CountDownLatch(this.memberCount);
    }

    public void releasePermit(ConcurrentToken token) throws InterruptedException {
        if (this.threadBarrierMember.tryAcquire()) {
            this.threadBarrier.countDown();
            this.threadBarrier.await();
            if (this.threadBarrierOwner.tryAcquire()) {
                token.releasePermits(this.memberCount);
            }
        } else {
            token.releasePermit();
        }
    }
}

