/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.column.filter;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.filter.ColumnFilter;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.util.ReactionMapping;
import ch.javasoft.util.ints.IntList;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnforcedFluxColumnFilter
implements ColumnFilter {
    private Map<String, IntList> enforceIndices = null;

    @Override
    public <Col extends Column> boolean keepColumn(Col column, Config config, ReactionMapping rmap) {
        this.ensureInitialized(config, rmap);
        boolean keep = true;
        for (String reac : this.enforceIndices.keySet()) {
            IntList sinds = this.enforceIndices.get(reac);
            boolean any = false;
            int j = 0;
            while (keep && j < sinds.size()) {
                boolean allowNeg;
                int sgn;
                int sind = sinds.getInt(j);
                if (sind < column.booleanSize()) {
                    sgn = column.get(sind) ? 0 : 1;
                    allowNeg = false;
                } else {
                    int nind = sind - column.booleanSize();
                    sgn = column.getNumericSignum(config.zero(), nind);
                    boolean bl = allowNeg = sgn < 0 ? this.allowNegativeFlux(rmap, sind, column.booleanSize()) : false;
                }
                keep &= allowNeg ? sgn != 0 : sgn > 0;
                any |= sgn != 0;
                ++j;
            }
            keep &= any;
        }
        return keep;
    }

    private boolean allowNegativeFlux(ReactionMapping rmap, int sind, int booleanSize) {
        return rmap.isReactionReversibleBySortedIndex(sind) && rmap.getSortedReactionIndexOfTwinPart(sind) >= booleanSize;
    }

    private void ensureInitialized(Config config, ReactionMapping rmap) {
        if (this.enforceIndices == null) {
            LinkedHashMap<String, IntList> map = new LinkedHashMap<String, IntList>();
            for (String reac : config.getReactionsToEnforce()) {
                map.put(reac, rmap.getByOriginalReactionName(reac, ReactionMapping.Layer.Sorted));
            }
            this.enforceIndices = map;
        }
    }
}

