/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.column;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.jbase.EntityMarshaller;
import ch.javasoft.jbase.VariableWidthTable;
import ch.javasoft.jbase.concurrent.ConcurrentTable;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.varint.VarIntFactory;
import ch.javasoft.math.varint.VarIntNumber;
import ch.javasoft.math.varint.ops.VarIntOperations;
import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.column.AbstractColumn;
import ch.javasoft.metabolic.efm.column.AbstractHome;
import ch.javasoft.metabolic.efm.column.BigIntegerColumn;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.column.VarIntMatrix;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.memory.outcore.Cache;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifier;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.util.BitSetUtil;
import ch.javasoft.metabolic.impl.FractionNumberFluxDistribution;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.util.numeric.Zero;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarIntColumn
extends AbstractColumn {
    private int mBoolSize;
    private int mNumeSize;
    private final IBitSet mBitSet;
    private byte[] mNumericRaw;
    public static final Home HOME = new Home(){

        @Override
        public Arithmetic getArithmetic() {
            return Arithmetic.varint;
        }

        @Override
        public NumberOperations<VarIntNumber> getNumberOperations() {
            return VarIntOperations.instance();
        }

        @Override
        public VarIntColumn newInstance(int booleanSize, int numericSize) {
            throw new RuntimeException("not implemented");
        }

        public VarIntColumn[] newInstances(ReadableMatrix<VarIntNumber> matrix, int booleanSize) {
            int rows = matrix.getRowCount();
            int cols = matrix.getColumnCount();
            VarIntColumn[] res = new VarIntColumn[cols];
            int col = 0;
            while (col < cols) {
                VarIntNumber[] vals = new VarIntNumber[rows];
                int row = 0;
                while (row < rows) {
                    vals[row] = matrix.getNumberValueAt(row, col);
                    ++row;
                }
                res[col] = new VarIntColumn(booleanSize, vals.length, BitSetUtil.factory().create(rows), VarIntColumn.fromVarIntNumber(vals));
                ++col;
            }
            return res;
        }

        @Override
        public VarIntColumn readFrom(DataInput dataIn, int booleanSize, int numericSize) throws IOException {
            IBitSet bitSet = this.readBinaryFrom(dataIn, booleanSize);
            int len = dataIn.readInt();
            byte[] arr = new byte[len];
            dataIn.readFully(arr);
            return new VarIntColumn(booleanSize, numericSize, bitSet, arr);
        }

        @Override
        public void writeTo(VarIntColumn column, DataOutput dataOut) throws IOException {
            this.writeBinaryTo(column, dataOut);
            dataOut.writeInt(column.mNumericRaw.length);
            dataOut.write(column.mNumericRaw);
        }

        @Override
        public EntityMarshaller<VarIntColumn> getEntityMarshaller(final int booleanSize, final int numericSize) throws IOException {
            return new EntityMarshaller<VarIntColumn>(){

                @Override
                public VarIntColumn readFrom(DataInput in) throws IOException {
                    return (VarIntColumn)HOME.readFrom(in, booleanSize, numericSize);
                }

                @Override
                public void writeTo(VarIntColumn entity, DataOutput out) throws IOException {
                    HOME.writeTo(entity, out);
                }
            };
        }

        @Override
        public ConcurrentTable<VarIntColumn> createTable(File folder, String fileName, int booleanSize, int numericSize) throws IOException {
            int boolByteLen = BitSetUtil.byteSize(booleanSize);
            int numericByteLen = 4 + numericSize * 8;
            return new ConcurrentTable<VarIntColumn>(VariableWidthTable.create(folder, fileName, boolByteLen + numericByteLen, this.getEntityMarshaller(booleanSize, numericSize), Cache.VarIntMemoryTable.getCacheTableSize(), Cache.VarIntMemoryTable.getCacheEntrySize()));
        }

        @Override
        public ConcurrentTable<VarIntColumn> openTable(File folder, String fileName, int booleanSize, int numericSize) throws IOException {
            return new ConcurrentTable<VarIntColumn>(VariableWidthTable.open(folder, fileName, this.getEntityMarshaller(booleanSize, numericSize), Cache.VarIntMemoryTable.getCacheTableSize(), Cache.VarIntMemoryTable.getCacheEntrySize()));
        }

        public FluxDistribution createFluxDistribution(MetabolicNetwork net, VarIntNumber[] values) {
            BigInteger[] bvalues = new BigInteger[values.length];
            int i = 0;
            while (i < bvalues.length) {
                bvalues[i] = values[i].toBigInteger();
                ++i;
            }
            return new FractionNumberFluxDistribution(net, bvalues);
        }

        @Override
        public ReadableMatrix<VarIntNumber> convertMatrix(ReadableMatrix matrix, boolean allowRowScaling, boolean allowColumnScaling) {
            if (matrix instanceof VarIntMatrix) {
                return (VarIntMatrix)matrix;
            }
            return new VarIntMatrix(BigIntegerColumn.HOME.convertMatrix(matrix, allowRowScaling, allowColumnScaling));
        }

        @Override
        public ReadableMatrix<VarIntNumber> castMatrix(ReadableMatrix matrix) {
            if (matrix instanceof VarIntMatrix) {
                return (VarIntMatrix)matrix;
            }
            throw new ClassCastException("not a VarIntMatrix: " + matrix.getClass().getName());
        }

        @Override
        public VarIntColumn castColumn(Column column) {
            return (VarIntColumn)column;
        }

        @Override
        public VarIntNumber castNumber(Number number) {
            return (VarIntNumber)number;
        }

        @Override
        public int rank(ReadableMatrix matrix, Zero zero) {
            return new Gauss(zero.mZeroPos).rank((ReadableBigIntegerRationalMatrix)matrix);
        }
    };

    public VarIntColumn(int boolSize) {
        this.mBoolSize = boolSize;
        this.mNumeSize = 0;
        this.mBitSet = BitSetUtil.factory().create(boolSize);
        this.mNumericRaw = new byte[0];
    }

    protected VarIntColumn(int boolSize, int numSize, IBitSet bitSet, byte[] numericRaw) {
        this.mBoolSize = boolSize;
        this.mNumeSize = numSize;
        this.mBitSet = bitSet;
        this.mNumericRaw = numericRaw;
    }

    @Override
    public IBitSet bitValues() {
        return this.mBitSet;
    }

    @Override
    public <N extends Number> N getNumeric(ColumnHome<N, ?> columnHome, int row) {
        VarIntNumber val = VarIntColumn.toVarIntNumber(this.mNumericRaw, row);
        return columnHome.castNumber(val);
    }

    private VarIntNumber[] toVarIntNumbers() {
        AtomicInteger offsetPtr = new AtomicInteger();
        VarIntNumber[] res = new VarIntNumber[this.mNumeSize];
        int i = 0;
        while (i < this.mNumeSize) {
            res[i] = VarIntFactory.readFrom(this.mNumericRaw, offsetPtr);
            ++i;
        }
        return res;
    }

    private static VarIntNumber toVarIntNumber(byte[] raw, int row) {
        AtomicInteger offsetPtr = VarIntColumn.getOffset(raw, row);
        return VarIntFactory.readFrom(raw, offsetPtr);
    }

    private static AtomicInteger getOffset(byte[] raw, int row) {
        AtomicInteger offsetPtr = new AtomicInteger();
        while (row > 0) {
            VarIntFactory.readFrom(raw, offsetPtr);
            --row;
        }
        return offsetPtr;
    }

    private static int toSignum(byte[] raw, int row) {
        return VarIntColumn.toVarIntNumber(raw, row).signum();
    }

    private static byte[] fromVarIntNumber(VarIntNumber[] values) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < values.length) {
            try {
                values[i].writeTo(out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        return out.toByteArray();
    }

    @Override
    public int booleanSize() {
        return this.mBoolSize;
    }

    @Override
    public int numericSize() {
        return this.mNumeSize;
    }

    public int size() {
        return this.mBoolSize + this.mNumeSize;
    }

    @Override
    public int getNumericSignum(Zero zero, int row) {
        return VarIntColumn.toSignum(this.mNumericRaw, row);
    }

    @Override
    public int getHyperplaneSign(EfmModel model, IterationStateModel iteration) {
        return VarIntColumn.getColumnInspectorModifier(model, VarIntNumber.class, VarIntNumber[].class).getHyperplaneSign(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.toVarIntNumbers(), iteration);
    }

    @Override
    public <Col extends Column> Col convert(ColumnHome<?, Col> columnHome, EfmModel model, IterationStepModel iteration, boolean clone) {
        VarIntNumber[] biValues = this.toVarIntNumbers();
        ColumnInspectorModifier<VarIntNumber, VarIntNumber[]> modifier = VarIntColumn.getColumnInspectorModifier(model, VarIntNumber.class, VarIntNumber[].class);
        IBitSet newBin = modifier.convertBinary(this.columnHome(), model, this.mBitSet, this.mBoolSize, biValues, iteration, clone);
        VarIntNumber[] newNum = modifier.convertNumeric(this.columnHome(), model, this.mBitSet, this.mBoolSize, biValues, iteration, clone);
        if (clone) {
            return columnHome.castColumn(new VarIntColumn(iteration.getNextState().getBooleanSize(), newNum.length, newBin, VarIntColumn.fromVarIntNumber(newNum)));
        }
        this.mBoolSize = iteration.getNextState().getBooleanSize();
        if (this.mBitSet != newBin) {
            this.mBitSet.clear();
            this.mBitSet.or(newBin);
        }
        this.mNumeSize = newNum.length;
        this.mNumericRaw = VarIntColumn.fromVarIntNumber(newNum);
        return columnHome.castColumn(this);
    }

    @Override
    public <Col extends Column> Col mergeWith(ColumnHome<?, Col> columnHome, EfmModel model, Col other, IterationStepModel iteration) {
        return columnHome.castColumn(this.mergeWith(model, (VarIntColumn)other, iteration));
    }

    public VarIntColumn mergeWith(EfmModel model, VarIntColumn other, IterationStepModel iteration) {
        VarIntNumber[] myValues = this.toVarIntNumbers();
        VarIntNumber[] otValues = other.toVarIntNumbers();
        ColumnInspectorModifier<VarIntNumber, VarIntNumber[]> modifier = VarIntColumn.getColumnInspectorModifier(model, VarIntNumber.class, VarIntNumber[].class);
        IBitSet newBin = modifier.mergeBinary(this.columnHome(), model, this.mBitSet, this.mBoolSize, myValues, other.mBitSet, other.mBoolSize, otValues, iteration);
        VarIntNumber[] newNum = modifier.mergeNumeric(this.columnHome(), model, this.mBitSet, this.mBoolSize, myValues, other.mBitSet, other.mBoolSize, otValues, iteration);
        return new VarIntColumn(iteration.getNextState().getBooleanSize(), newNum.length, newBin, VarIntColumn.fromVarIntNumber(newNum));
    }

    @Override
    public void writeTo(DataOutput dataOut) throws IOException {
        this.columnHome().writeTo(this, dataOut);
    }

    @Override
    public VarIntColumn clone() {
        return new VarIntColumn(this.mBoolSize, this.mNumeSize, this.mBitSet.clone(), (byte[])this.mNumericRaw.clone());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof VarIntColumn) {
            VarIntColumn col = (VarIntColumn)obj;
            return this.mBoolSize == col.mBoolSize && this.mBitSet.equals(col.mBitSet) && Arrays.equals(this.mNumericRaw, col.mNumericRaw);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        int ii = 0;
        while (ii < this.mBoolSize) {
            sb.append(this.mBitSet.get(ii) ? (char)'1' : '0');
            ++ii;
        }
        ii = 0;
        while (ii < this.mNumeSize) {
            if (this.mBoolSize > 0 || ii > 0) {
                sb.append(", ");
            }
            sb.append(VarIntColumn.toVarIntNumber(this.mNumericRaw, ii));
            ++ii;
        }
        sb.append('}');
        return sb.toString();
    }

    public Home columnHome() {
        return HOME;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Home
    extends AbstractHome<VarIntNumber, VarIntColumn>
    implements ColumnHome<VarIntNumber, VarIntColumn> {
    }
}

