/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.range;

import ch.javasoft.metabolic.efm.borndie.range.CellRange;
import ch.javasoft.metabolic.efm.borndie.range.DefaultCellRange;
import ch.javasoft.metabolic.efm.borndie.range.Range;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowerTriangularMatrix
implements Range {
    private final int length;

    public LowerTriangularMatrix(int length) {
        this.length = length;
    }

    public int getRowCount() {
        return this.length;
    }

    public int getColumnCount() {
        return this.length;
    }

    public int getRowFrom(int column) {
        return column;
    }

    public int getRowTo(int column) {
        return this.length;
    }

    public int getColumnFrom(int row) {
        return 0;
    }

    public int getColumnTo(int row) {
        return row + 1;
    }

    public int getColumnHeight(int column) {
        return this.length - column;
    }

    public int getRowWidth(int row) {
        return row + 1;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public boolean contains(CellRange cell) {
        return this.contains(cell.getBornColumn(), cell.getDieRow());
    }

    @Override
    public boolean contains(int bornColumn, int dieRow) {
        return bornColumn >= 0 && dieRow >= bornColumn && dieRow < this.length;
    }

    public int getFinalRow() {
        return this.getLength() - 1;
    }

    public boolean isFinalRow(int dieRow) {
        return dieRow == this.getFinalRow();
    }

    @Override
    public int getCellCount() {
        return this.length * (this.length + 1) / 2;
    }

    public int cellToIndex(int bornCol, int dieRow) throws IndexOutOfBoundsException {
        if (dieRow < 0) {
            throw new IndexOutOfBoundsException("negative row index: " + dieRow);
        }
        if (bornCol < 0) {
            throw new IndexOutOfBoundsException("negative column index: " + bornCol);
        }
        if (dieRow >= this.length) {
            throw new IndexOutOfBoundsException("row index >= length: " + dieRow + " >= " + this.length);
        }
        if (bornCol >= this.length) {
            throw new IndexOutOfBoundsException("column index >= length: " + bornCol + " >= " + this.length);
        }
        if (bornCol > dieRow) {
            throw new IndexOutOfBoundsException("column index is larger than row index: " + bornCol + " > " + dieRow);
        }
        return bornCol * this.length - (bornCol * bornCol + bornCol) / 2 + dieRow;
    }

    public CellRange indexToCell(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("negative index: " + index);
        }
        if (index >= this.getCellCount()) {
            throw new IndexOutOfBoundsException("index after last cell: " + index + ">=" + this.getCellCount());
        }
        int col = 0;
        while (col < this.length) {
            int colSize = this.length - col;
            if (index < colSize) {
                return new DefaultCellRange(col, index + col);
            }
            index -= colSize;
            ++col;
        }
        throw new IndexOutOfBoundsException("not in cell: " + index + " >= " + this.getCellCount());
    }

    @Override
    public Iterator<CellRange> iterator() {
        return new Iterator<CellRange>(){
            int row = 0;
            int col = 0;

            @Override
            public boolean hasNext() {
                return this.row < LowerTriangularMatrix.this.length;
            }

            @Override
            public CellRange next() {
                int cur = this.row;
                if (this.row < LowerTriangularMatrix.this.length) {
                    ++this.row;
                    if (this.row >= LowerTriangularMatrix.this.length && this.col + 1 < LowerTriangularMatrix.this.length) {
                        this.row = 0;
                        ++this.col;
                    }
                    return new DefaultCellRange(this.col, cur);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("immutable");
            }
        };
    }

    public int hashCode() {
        return this.length;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LowerTriangularMatrix) {
            LowerTriangularMatrix other = (LowerTriangularMatrix)obj;
            return this.getLength() == other.getLength();
        }
        return false;
    }

    public String toString() {
        return "Tril{" + this.getLength() + "}";
    }
}

