/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.memory;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.memory.IndexableMemory;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.util.MappingUtil;
import ch.javasoft.util.IntArray;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedSortableMemory<Col extends Column>
implements SortableMemory<Col> {
    private final IndexableMemory<Col> baseMemory;
    private final int[] mapping;

    public MappedSortableMemory(IndexableMemory<Col> baseMemory) throws IOException {
        this.baseMemory = baseMemory;
        this.mapping = MappingUtil.getInitialMapping(baseMemory.getColumnCount());
    }

    @Override
    public String fileId() throws IOException {
        return this.baseMemory.fileId();
    }

    @Override
    public int getColumnCount() throws IOException {
        return this.mapping.length;
    }

    @Override
    public Col getColumn(int index) throws IOException {
        return this.baseMemory.getColumn(this.mapping[index]);
    }

    @Override
    public Iterator<Col> iterator() {
        return new Iterator<Col>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < MappedSortableMemory.this.mapping.length;
            }

            @Override
            public Col next() {
                try {
                    Object col = MappedSortableMemory.this.getColumn(this.index);
                    ++this.index;
                    return col;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not modifiable");
            }
        };
    }

    @Override
    public void swapColumns(int indexA, int indexB) throws IOException {
        IntArray.swap(this.mapping, indexA, indexB);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close(boolean erase) throws IOException {
        if (erase) {
            throw new IllegalArgumentException("cannot erase a filtered memory");
        }
        this.baseMemory.close(false);
    }
}

