/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree.urank;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.adj.incore.tree.AbstractTreeFactory;
import ch.javasoft.metabolic.efm.adj.incore.tree.InterNode;
import ch.javasoft.metabolic.efm.adj.incore.tree.Node;
import ch.javasoft.metabolic.efm.adj.incore.tree.Root;
import ch.javasoft.metabolic.efm.adj.incore.tree.Traverser;
import ch.javasoft.metabolic.efm.adj.incore.tree.TreeFactory;
import ch.javasoft.metabolic.efm.adj.incore.tree.urank.RankUpdateRoot;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.concurrent.RankUpdateToken;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.rankup.PreprocessableMatrix;
import ch.javasoft.metabolic.efm.rankup.PreprocessedMatrix;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RankUpdateTreeFactory
extends AbstractTreeFactory<RankUpdateToken> {
    public RankUpdateTreeFactory(EfmModel efmModel) {
        super(efmModel);
    }

    @Override
    public InterNode<RankUpdateToken> createInterNode(SortableMemory<Column> cols, int[] selectiveBits, int prevSelBitIndex, int iStart, int iEnd) throws IOException {
        return new InterNode<RankUpdateToken>((TreeFactory)this, cols, selectiveBits, prevSelBitIndex, iStart, iEnd){

            @Override
            public void addAdjacentPairs(final RankUpdateToken token, final Root<RankUpdateToken> root, final SortableMemory<Column> posCols, final SortableMemory<Column> zeroCols, final SortableMemory<Column> negCols, Node<RankUpdateToken> partner, final boolean thisIsPos, final Queue<ColumnPair> adjacentPairs) throws IOException {
                if (root.enterIfCandidates(token, this, partner)) {
                    if (partner instanceof InterNode) {
                        final InterNode interPartner = (InterNode)partner;
                        if (token.tryAcquirePermit()) {
                            Callable<Void> callable = new Callable<Void>(){

                                @Override
                                public Void call() {
                                    try {
                                        try {
                                            child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child0, thisIsPos, adjacentPairs);
                                            child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child1, thisIsPos, adjacentPairs);
                                        }
                                        catch (IOException ex) {
                                            throw new RuntimeException(ex);
                                        }
                                    }
                                    finally {
                                        token.releasePermit();
                                    }
                                    return null;
                                }
                            };
                            token.createChildThread(callable, null).start();
                            this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child0, thisIsPos, adjacentPairs);
                            this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child1, thisIsPos, adjacentPairs);
                        } else {
                            this.child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child0, thisIsPos, adjacentPairs);
                            this.child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child1, thisIsPos, adjacentPairs);
                            this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child0, thisIsPos, adjacentPairs);
                            this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child1, thisIsPos, adjacentPairs);
                        }
                    } else {
                        this.child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, partner, thisIsPos, adjacentPairs);
                        this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, partner, thisIsPos, adjacentPairs);
                    }
                    root.leave(token, this, partner);
                }
            }
        };
    }

    @Override
    public Traverser<RankUpdateToken> createTraverser() {
        return new Traverser<RankUpdateToken>(){

            @Override
            public void traverseTree(Root<RankUpdateToken> root, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, Queue<ColumnPair> adjacentPairs) throws IOException {
                RankUpdateToken token = new RankUpdateToken(RankUpdateTreeFactory.this.efmModel);
                if (token.tryAcquirePermit()) {
                    IBitSet cut = root.pos().unionPattern.getAnd(root.neg().unionPattern);
                    token.addRootRankMatrix(cut);
                    root.pos().addAdjacentPairs(token, root, posCols, zeroCols, negCols, root.neg(), true, adjacentPairs);
                    token.removeRootRankMatrix();
                    token.releasePermit();
                    try {
                        token.waitForChildThreads();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    throw new RuntimeException("no initial thread");
                }
            }
        };
    }

    protected abstract PreprocessedMatrix createInitialPreprocessedMatrix(PreprocessableMatrix var1, RankUpdateToken var2, RankUpdateRoot var3);

    protected abstract PreprocessedMatrix createChildPreprocessedMatrix(PreprocessableMatrix var1, RankUpdateToken var2, RankUpdateRoot var3, PreprocessedMatrix var4);
}

