/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm;

import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.efm.ElementaryFluxModes;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.util.LinearProgramming;
import ch.javasoft.util.logging.Loggers;
import java.util.logging.Level;
import junit.framework.TestCase;

public class LpTest
extends TestCase {
    static {
        CompressionMethod[] compression = CompressionMethod.STANDARD;
        if (Config.initForJUnitTest("pattern-tree-minzero", compression, Arithmetic.fractional)) {
            Loggers.getRootLogger().setLevel(Level.FINE);
        }
    }

    public void testCormen781() {
        double[] cost = new double[]{2.0, -3.0, 3.0};
        double[][] mxA = new double[][]{{1.0, 1.0, -1.0}, {-1.0, -1.0, 1.0}, {1.0, -2.0, 2.0}};
        double[] b = new double[]{7.0, -7.0, 4.0};
        double[][] mxB = LinearProgramming.standardToSlackForm(mxA, b);
        boolean[] reversible = new boolean[]{};
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(mxB, reversible);
        ElementaryFluxModes.calculateLogMinMax(metaNet, cost, true);
    }

    public void testCormen791() {
        double[] cost = new double[]{3.0, 1.0, 2.0};
        double[][] mxA = new double[][]{{1.0, 1.0, 3.0}, {2.0, 2.0, 5.0}, {4.0, 1.0, 2.0}};
        double[] b = new double[]{30.0, 24.0, 36.0};
        double[][] mxB = LinearProgramming.standardToSlackForm(mxA, b);
        boolean[] reversible = new boolean[]{};
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(mxB, reversible);
        ElementaryFluxModes.calculateLogMinMax(metaNet, cost, true);
    }

    public void testQubeSATx1a() {
        double[] cost = new double[]{1.0, 1.0, 1.0};
        double[][] mxA = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 1.0, 1.0}};
        double[] b = new double[]{1.0, 1.0, 1.0, 2.0};
        double[][] mxB = LinearProgramming.standardToSlackForm(mxA, b);
        boolean[] reversible = new boolean[]{};
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(mxB, reversible);
        ElementaryFluxModes.calculateLogMinMax(metaNet, cost, true);
    }

    public void testQubeSATx1b() {
        double[] cost = new double[]{1.0, 1.0, 1.0};
        double[][] mxA = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {-1.0, 1.0, 1.0}};
        double[] b = new double[]{1.0, 1.0, 1.0, 1.0};
        double[][] mxB = LinearProgramming.standardToSlackForm(mxA, b);
        boolean[] reversible = new boolean[]{};
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(mxB, reversible);
        ElementaryFluxModes.calculateLogMinMax(metaNet, cost, true);
    }

    public void testQubeSATx2() {
        double[] cost = new double[]{1.0, 1.0, 1.0};
        double[][] mxA = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 1.0, 1.0}, {-1.0, 1.0, 1.0}, {0.0, 1.0, 1.0}};
        double[] b = new double[]{1.0, 1.0, 1.0, 2.0, 1.0, 1.0};
        double[][] mxB = LinearProgramming.standardToSlackForm(mxA, b);
        boolean[] reversible = new boolean[]{};
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(mxB, reversible);
        ElementaryFluxModes.calculateLogMinMax(metaNet, cost, true);
    }

    public void testQubeSATx3() {
        double[] cost = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        double[][] mxA = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0}, {1.0, 1.0, 1.0, 0.0, 0.0}, {-1.0, 1.0, 0.0, 1.0, 0.0}, {0.0, 0.0, -1.0, -1.0, -1.0}};
        double[] b = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, -1.0};
        double[][] mxB = LinearProgramming.standardToSlackForm(mxA, b);
        boolean[] reversible = new boolean[]{};
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(mxB, reversible);
        ElementaryFluxModes.calculateLogMinMax(metaNet, cost, true);
    }

    public void testQubeSATx3ab() {
        double[] cost = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        double[][] mxA = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0}, {1.0, 1.0, 1.0, 0.0, 0.0}, {-1.0, 1.0, 0.0, 1.0, 0.0}, {0.0, 0.0, -1.0, -1.0, -1.0}, {0.0, 2.0, 1.0, 1.0, 0.0}};
        double[] b = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, -1.0, 3.0};
        double[][] mxB = LinearProgramming.standardToSlackForm(mxA, b);
        boolean[] reversible = new boolean[]{};
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(mxB, reversible);
        ElementaryFluxModes.calculateLogMinMax(metaNet, cost, true);
    }

    public void testQubeSATx3abMod() {
        double[] cost = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        double[][] mxA = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0}, {1.0, 1.0, 1.0, 0.0, 0.0}, {-1.0, 1.0, 0.0, 1.0, 0.0}, {0.0, 0.0, -1.0, -1.0, -1.0}, {0.0, 1.0, 1.0, 1.0, 0.0}};
        double[] b = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, -1.0, 2.0};
        double[][] mxB = LinearProgramming.standardToSlackForm(mxA, b);
        boolean[] reversible = new boolean[]{};
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(mxB, reversible);
        ElementaryFluxModes.calculateLogMinMax(metaNet, cost, true);
    }

    public void testQubeSATx3abbcac() {
        double[] cost = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        double[][] mxA = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0}, {1.0, 1.0, 1.0, 0.0, 0.0}, {-1.0, 1.0, 0.0, 1.0, 0.0}, {0.0, 0.0, -1.0, -1.0, -1.0}, {0.0, 1.0, 1.0, 1.0, 0.0}, {-1.0, 1.0, -1.0, 0.0, -1.0}, {1.0, 1.0, 0.0, -1.0, -1.0}};
        double[] b = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, -1.0, 2.0, 0.0, 1.0};
        double[][] mxB = LinearProgramming.standardToSlackForm(mxA, b);
        boolean[] reversible = new boolean[]{};
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(mxB, reversible);
        ElementaryFluxModes.calculateLogMinMax(metaNet, cost, true);
    }
}

