/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.compress;

import ch.javasoft.math.BigFraction;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.compress.CompressionStatistics;
import ch.javasoft.metabolic.compress.LogPkg;
import ch.javasoft.metabolic.impl.AbstractReaction;
import ch.javasoft.metabolic.impl.DefaultMetabolite;
import ch.javasoft.metabolic.impl.FractionNumberStoichMetabolicNetwork;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.IntArray;
import ch.javasoft.util.ints.BitSetIntSet;
import ch.javasoft.util.ints.DefaultIntList;
import ch.javasoft.util.ints.IntIterable;
import ch.javasoft.util.ints.IntIterator;
import ch.javasoft.util.logging.LogPrintWriter;
import ch.javasoft.util.logging.Loggers;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoichMatrixCompressor {
    private static final Logger LOG = LogPkg.LOGGER;
    private final CompressionMethod[] mCompressionMethods;

    public StoichMatrixCompressor() {
        this(CompressionMethod.STANDARD);
    }

    public StoichMatrixCompressor(CompressionMethod ... compressionMethods) {
        this.mCompressionMethods = compressionMethods;
        CompressionMethod.logUnsupported(Level.WARNING, compressionMethods, CompressionMethod.CoupledZero, CompressionMethod.CoupledCombine, CompressionMethod.CoupledContradicting, CompressionMethod.UniqueFlows, CompressionMethod.DeadEnd, CompressionMethod.Recursive);
    }

    public CompressionRecord compress(ReadableBigIntegerRationalMatrix stoich, boolean[] reversible, String[] metaNames, String[] reacNames, Set<String> suppressedReactions) {
        int itCount;
        boolean doDea;
        WorkRecord workRecord = new WorkRecord(stoich, reversible, metaNames, reacNames);
        boolean doRec = CompressionMethod.Recursive.containedIn(this.mCompressionMethods);
        boolean doZer = CompressionMethod.CoupledZero.containedIn(this.mCompressionMethods);
        boolean doCon = CompressionMethod.CoupledContradicting.containedIn(this.mCompressionMethods);
        boolean doCom = CompressionMethod.CoupledCombine.containedIn(this.mCompressionMethods);
        boolean doUnq = CompressionMethod.UniqueFlows.containedIn(this.mCompressionMethods);
        boolean doUnqInc = doDea = CompressionMethod.DeadEnd.containedIn(this.mCompressionMethods);
        boolean doUnqCom = doUnq;
        boolean doNulInc = doZer || doCon;
        boolean doNulCom = doCom;
        boolean compressedAny = workRecord.removeReactions(suppressedReactions);
        do {
            itCount = workRecord.stats.incCompressionIteration();
            LOG.fine("compression iteration " + (itCount + 1) + " (dead-ends/inconsistencies)");
            compressedAny = doUnqInc && workRecord.removeUnusedMetabolites();
            compressedAny |= doUnqInc && this.unique(workRecord, false);
            compressedAny |= doNulInc && workRecord.removeUnusedMetabolites();
        } while ((compressedAny |= doNulInc && this.nullspace(workRecord, false)) && doRec);
        if (doUnqCom) {
            do {
                itCount = workRecord.stats.incCompressionIteration();
                LOG.fine("compression iteration " + (itCount + 1) + " (unique fluxes)");
                compressedAny = workRecord.removeUnusedMetabolites();
            } while ((compressedAny |= this.unique(workRecord, true)) && doRec);
            if (compressedAny && !doRec) {
                workRecord.removeUnusedMetabolites();
            }
        }
        if (doNulCom) {
            do {
                itCount = workRecord.stats.incCompressionIteration();
                LOG.fine("compression iteration " + (itCount + 1) + " (nullspace)");
                compressedAny = workRecord.removeUnusedMetabolites();
            } while ((compressedAny |= this.nullspace(workRecord, true)) && doRec);
            if (compressedAny && !doRec) {
                workRecord.removeUnusedMetabolites();
            }
        }
        if (doRec && doUnqCom && doNulCom) {
            do {
                itCount = workRecord.stats.incCompressionIteration();
                LOG.fine("compression iteration " + (itCount + 1) + " (unique/nullspace)");
                compressedAny = workRecord.removeUnusedMetabolites();
                compressedAny |= this.unique(workRecord, true);
                compressedAny |= workRecord.removeUnusedMetabolites();
            } while ((compressedAny |= this.nullspace(workRecord, true)) && doRec);
        }
        workRecord.stats.writeToLog();
        return workRecord.getTruncated();
    }

    private boolean nullspace(WorkRecord workRecord, boolean inclCompression) {
        boolean doZer = CompressionMethod.CoupledZero.containedIn(this.mCompressionMethods);
        boolean doCon = CompressionMethod.CoupledContradicting.containedIn(this.mCompressionMethods);
        boolean doCom = CompressionMethod.CoupledCombine.containedIn(this.mCompressionMethods);
        boolean doCpl = doCon || doCom;
        NullspaceRecord nullspaceRecord = new NullspaceRecord(workRecord);
        boolean compressedAny = false;
        if (doZer) {
            compressedAny |= this.nullspaceZeroFluxReactions(nullspaceRecord);
        }
        if (doCpl) {
            compressedAny |= this.nullspaceCoupledReactions(nullspaceRecord, inclCompression);
        }
        if (compressedAny) {
            workRecord.removeUnusedMetabolites();
        }
        return compressedAny;
    }

    private boolean nullspaceZeroFluxReactions(NullspaceRecord nullspaceRecord) {
        Size size = nullspaceRecord.size;
        BigIntegerRationalMatrix kernel = nullspaceRecord.kernel;
        boolean anyZeroFlux = false;
        int cols = kernel.getColumnCount();
        int reac = 0;
        while (reac < size.reacs) {
            boolean allZero = true;
            int col = 0;
            while (col < cols) {
                if (!StoichMatrixCompressor.isZero(kernel.getBigIntegerNumeratorAt(reac, col))) {
                    allZero = false;
                    break;
                }
                ++col;
            }
            if (allZero) {
                LOG.fine("found and removed zero flux reaction: " + nullspaceRecord.reacNames[reac]);
                if (StoichMatrixCompressor.logFiner()) {
                    LOG.finer("    [-] " + nullspaceRecord.getReactionDetails(reac));
                }
                anyZeroFlux = true;
                nullspaceRecord.removeReaction(reac);
                nullspaceRecord.stats.incZeroFluxReactions();
                continue;
            }
            ++reac;
        }
        return anyZeroFlux;
    }

    private boolean nullspaceCoupledReactions(NullspaceRecord nullspaceRecord, boolean inclCompression) {
        boolean doCon = CompressionMethod.CoupledContradicting.containedIn(this.mCompressionMethods);
        boolean doCom = CompressionMethod.CoupledCombine.containedIn(this.mCompressionMethods);
        BigIntegerRationalMatrix kernel = nullspaceRecord.kernel;
        BigIntegerRationalMatrix stoich = nullspaceRecord.cmp;
        BigIntegerRationalMatrix post = nullspaceRecord.post;
        boolean[] reversible = nullspaceRecord.reversible;
        Size size = nullspaceRecord.size;
        int cols = kernel.getColumnCount();
        int reacs = size.reacs;
        ArrayList<IntArray> groups = new ArrayList<IntArray>();
        BigFraction[] ratios = new BigFraction[reacs];
        int reacA = 0;
        while (reacA < reacs) {
            if (ratios[reacA] == null) {
                IntArray group = null;
                int reacB = reacA + 1;
                while (reacB < reacs) {
                    BigFraction ratio = null;
                    int col = 0;
                    while (col < cols) {
                        boolean isZeroB;
                        boolean isZeroA = StoichMatrixCompressor.isZero(kernel.getBigIntegerNumeratorAt(reacA, col));
                        if (isZeroA != (isZeroB = StoichMatrixCompressor.isZero(kernel.getBigIntegerNumeratorAt(reacB, col)))) {
                            ratio = BigFraction.ZERO;
                            break;
                        }
                        if (!isZeroA) {
                            BigFraction valA = kernel.getBigFractionValueAt(reacA, col);
                            BigFraction valB = kernel.getBigFractionValueAt(reacB, col);
                            BigFraction curRatio = valA.divide(valB).reduce();
                            if (ratio == null) {
                                ratio = curRatio;
                            } else if (ratio.compareTo(curRatio) != 0) {
                                ratio = BigFraction.ZERO;
                                break;
                            }
                        }
                        ++col;
                    }
                    if (ratio == null) {
                        throw new RuntimeException("no zero rows expected here");
                    }
                    if (!StoichMatrixCompressor.isZero(ratio.getNumerator())) {
                        ratios[reacB] = ratio;
                        if (group == null) {
                            group = new IntArray();
                            group.add(reacA);
                        }
                        group.add(reacB);
                    }
                    ++reacB;
                }
                if (group != null) {
                    groups.add(group);
                }
            }
            ++reacA;
        }
        BitSet toRemove = new BitSet();
        for (IntArray grp : groups) {
            int reac;
            int i;
            boolean allOk;
            boolean forward = false;
            do {
                forward = !forward;
                allOk = forward || reversible[grp.first()];
                i = 1;
                while (i < grp.length() && allOk) {
                    reac = grp.get(i);
                    allOk &= forward == ratios[reac].signum() > 0 || reversible[reac];
                    ++i;
                }
            } while (forward && !allOk);
            if (!allOk) {
                if (doCon) {
                    if (StoichMatrixCompressor.logFine()) {
                        LOG.fine("found and removed inconsistently coupled reactions: " + nullspaceRecord.getReactionNames(grp));
                    }
                    i = 0;
                    while (i < grp.length()) {
                        reac = grp.get(i);
                        if (StoichMatrixCompressor.logFiner()) {
                            String prefix = "   [-] r=" + (i == 0 ? BigFraction.ONE : ratios[reac]) + ": ";
                            nullspaceRecord.logReactionDetails(Level.FINER, prefix, reac);
                        }
                        toRemove.set(reac);
                        nullspaceRecord.stats.incContradictingReactions();
                        ++i;
                    }
                    continue;
                }
                LOG.finer("ignoring inconsistently coupled reactions due to compression settings");
                continue;
            }
            if (doCom && inclCompression) {
                if (StoichMatrixCompressor.logFine()) {
                    LOG.fine("found and combined coupled reactions: " + nullspaceRecord.getReactionNames(grp));
                }
                int masterReac = grp.first();
                if (StoichMatrixCompressor.logFiner()) {
                    String prefix = "   [+] r=" + (forward ? 1 : -1) + ": ";
                    nullspaceRecord.logReactionDetails(Level.FINER, prefix, masterReac);
                }
                if (!forward) {
                    StoichMatrixCompressor.negateColumn(stoich, masterReac);
                    StoichMatrixCompressor.negateColumn(post, masterReac);
                }
                int i2 = 1;
                while (i2 < grp.length()) {
                    BigFraction ratio;
                    int reac2 = grp.get(i2);
                    BigFraction bigFraction = ratio = forward ? ratios[reac2] : ratios[reac2].negate();
                    if (StoichMatrixCompressor.logFiner()) {
                        String prefix = "   [-] r=" + ratios[reac2] + ": ";
                        nullspaceRecord.logReactionDetails(Level.FINER, prefix, reac2);
                    }
                    StoichMatrixCompressor.addColumnMultipleTo(stoich, masterReac, reac2, ratio);
                    StoichMatrixCompressor.addColumnMultipleTo(post, masterReac, reac2, ratio);
                    int n = masterReac;
                    reversible[n] = reversible[n] & reversible[reac2];
                    toRemove.set(reac2);
                    nullspaceRecord.stats.incCoupledReactions();
                    ++i2;
                }
                if (StoichMatrixCompressor.logFiner()) {
                    LOG.finer("   [>] " + nullspaceRecord.getReactionDetails(masterReac));
                }
                boolean allZero = false;
                int meta = 0;
                while (meta < size.metas && allZero) {
                    allZero &= StoichMatrixCompressor.isZero(stoich.getBigIntegerNumeratorAt(meta, masterReac));
                    ++meta;
                }
                if (!allZero) continue;
                throw new RuntimeException("all entries found 0 for a reaction after merging: " + masterReac);
            }
            if (!inclCompression || doCom) continue;
            LOG.finer("ignoring coupled reactions due to compression settings");
        }
        nullspaceRecord.removeReactions(toRemove);
        return !toRemove.isEmpty();
    }

    private boolean unique(WorkRecord workRecord, boolean inclCompression) {
        Size size = workRecord.size;
        Size orig = size.clone();
        int meta = 0;
        while (meta < size.metas) {
            int metas = size.metas;
            this.uniqueMeta(workRecord, meta, inclCompression);
            if (metas != size.metas) continue;
            ++meta;
        }
        return !orig.equals(size);
    }

    private boolean uniqueMeta(WorkRecord workRecord, int meta, boolean inclCompression) {
        BigIntegerRationalMatrix stoich = workRecord.cmp;
        BigIntegerRationalMatrix post = workRecord.post;
        boolean[] reversible = workRecord.reversible;
        Size size = workRecord.size;
        BitSet eduReacs = new BitSet();
        BitSet proReacs = new BitSet();
        BitSet revReacs = new BitSet();
        int reac = 0;
        while (reac < size.reacs) {
            int sgn = stoich.getSignumAt(meta, reac);
            if (sgn != 0) {
                if (reversible[reac]) {
                    revReacs.set(reac);
                } else if (sgn < 0) {
                    eduReacs.set(reac);
                } else if (sgn > 0) {
                    proReacs.set(reac);
                }
            }
            ++reac;
        }
        int eduCnt = eduReacs.cardinality();
        int proCnt = proReacs.cardinality();
        int revCnt = revReacs.cardinality();
        if (eduCnt == 0 && proCnt == 0 && revCnt == 0) {
            if (StoichMatrixCompressor.logFine()) {
                LOG.fine("found and removed unused metabolite: " + workRecord.metaNames[meta]);
            }
            workRecord.removeMetabolite(meta, true);
            workRecord.stats.incUnusedMetabolite();
            return true;
        }
        if (eduCnt == 0 && proCnt == 0 && revCnt == 1 || eduCnt == 0 && revCnt == 0 || proCnt == 0 && revCnt == 0) {
            BitSet allReacs = (BitSet)eduReacs.clone();
            allReacs.or(proReacs);
            allReacs.or(revReacs);
            if (StoichMatrixCompressor.logFine()) {
                LOG.fine("found and removed dead-end metabolite/reaction(s): " + workRecord.metaNames[meta] + " / " + workRecord.getReactionNames(allReacs));
                workRecord.logReactionDetails(Level.FINER, "   ", allReacs);
            }
            workRecord.removeMetabolite(meta, true);
            workRecord.removeReactions(allReacs);
            workRecord.stats.incDeadEndMetaboliteReactions(allReacs.cardinality());
            return true;
        }
        if (inclCompression) {
            int reacToRemove = -1;
            BitSet reacsToMerge = null;
            if (revCnt == 0 && (eduCnt == 1 || proCnt == 1)) {
                reacToRemove = eduCnt == 1 ? eduReacs.nextSetBit(0) : proReacs.nextSetBit(0);
                reacsToMerge = eduCnt == 1 ? proReacs : eduReacs;
                LOG.fine("found uniquely " + (eduCnt == 1 ? "consumed" : "produced") + " metabolite: " + workRecord.metaNames[meta]);
            } else if (revCnt == 1 && (eduCnt == 0 || proCnt == 0)) {
                reacToRemove = revReacs.nextSetBit(0);
                reacsToMerge = eduCnt == 0 ? proReacs : eduReacs;
                LOG.fine("found uniquely (reversibly) " + (eduCnt == 0 ? "consumed" : "produced") + " metabolite: " + workRecord.metaNames[meta]);
            } else if (revCnt == 2 && eduCnt == 0 && proCnt == 0) {
                reacToRemove = revReacs.nextSetBit(0);
                reacsToMerge = new BitSet();
                reacsToMerge.set(revReacs.nextSetBit(reacToRemove + 1));
                LOG.fine("found and removed metabolite between 2 reversible reactions: " + workRecord.metaNames[meta] + " / " + workRecord.getReactionNames(revReacs));
            }
            if (reacsToMerge != null) {
                workRecord.logReactionDetails(Level.FINER, "   [-] ", reacToRemove);
                BigFraction rmStoich = stoich.getBigFractionValueAt(meta, reacToRemove);
                BigFraction kpMul = rmStoich.abs();
                int reac2 = reacsToMerge.nextSetBit(0);
                while (reac2 >= 0) {
                    workRecord.logReactionDetails(Level.FINER, "   [+] ", reac2);
                    BigFraction kpStoich = stoich.getBigFractionValueAt(meta, reac2);
                    BigFraction rmMul = rmStoich.signum() < 0 ? kpStoich : kpStoich.negate();
                    StoichMatrixCompressor.addColumnMultipleTo(stoich, reac2, kpMul, reacToRemove, rmMul);
                    StoichMatrixCompressor.addColumnMultipleTo(post, reac2, kpMul, reacToRemove, rmMul);
                    int n = reac2;
                    reversible[n] = reversible[n] & reversible[reacToRemove];
                    workRecord.logReactionDetails(Level.FINER, "   [>] ", reac2);
                    if (stoich.getSignumAt(meta, reac2) != 0) {
                        throw new RuntimeException("internal error: stoichiometry for eliminated metabolite " + workRecord.metaNames[meta] + " expected to be zero, but was " + stoich.getBigFractionValueAt(meta, reac2));
                    }
                    reac2 = reacsToMerge.nextSetBit(reac2 + 1);
                }
                workRecord.removeMetabolite(meta, true);
                workRecord.removeReaction(reacToRemove);
                workRecord.stats.incUniqueFlowReactions();
                return true;
            }
        }
        return false;
    }

    private static void negateColumn(BigIntegerRationalMatrix mx, int col) {
        int rows = mx.getRowCount();
        int row = 0;
        while (row < rows) {
            BigInteger num = mx.getBigIntegerNumeratorAt(row, col);
            BigInteger den = mx.getBigIntegerDenominatorAt(row, col);
            mx.setValueAt(row, col, num.negate(), den);
            ++row;
        }
    }

    private static void addColumnMultipleTo(BigIntegerRationalMatrix mx, int dstCol, BigFraction dstMul, int srcCol, BigFraction srcMul) {
        int rows = mx.getRowCount();
        int row = 0;
        while (row < rows) {
            if (mx.getSignumAt(row, srcCol) != 0 || mx.getSignumAt(row, dstCol) != 0) {
                BigFraction add = mx.getBigFractionValueAt(row, srcCol).multiply(srcMul);
                mx.multiply(row, dstCol, dstMul.getNumerator(), dstMul.getDenominator());
                mx.add(row, dstCol, add.getNumerator(), add.getDenominator());
                mx.reduceValueAt(row, dstCol);
            }
            ++row;
        }
    }

    private static void addColumnMultipleTo(BigIntegerRationalMatrix mx, int dstCol, int srcCol, BigFraction dstToSrcRatio) {
        int rows = mx.getRowCount();
        int row = 0;
        while (row < rows) {
            if (mx.getSignumAt(row, srcCol) != 0) {
                BigFraction add = mx.getBigFractionValueAt(row, srcCol).divide(dstToSrcRatio);
                mx.add(row, dstCol, add.getNumerator(), add.getDenominator());
                mx.reduceValueAt(row, dstCol);
            }
            ++row;
        }
    }

    private static BigIntegerRationalMatrix cancel(ReadableBigIntegerRationalMatrix matrix) {
        BigIntegerRationalMatrix mx = matrix.toBigIntegerRationalMatrix(true);
        mx.reduce();
        return mx;
    }

    private static BigIntegerRationalMatrix identity(int size) {
        DefaultBigIntegerRationalMatrix id = new DefaultBigIntegerRationalMatrix(size, size);
        int piv = 0;
        while (piv < size) {
            id.setValueAt(piv, piv, BigFraction.ONE);
            ++piv;
        }
        return id;
    }

    private static BigIntegerRationalMatrix createSubStoich(ReadableBigIntegerRationalMatrix pre, ReadableBigIntegerRationalMatrix stoich, ReadableBigIntegerRationalMatrix post, boolean[] reversible, Size size) {
        return stoich.subBigIntegerRationalMatrix(0, size.metas, 0, size.reacs);
    }

    private static boolean isZero(BigInteger val) {
        return val.signum() == 0;
    }

    private static boolean logFine() {
        return Loggers.isLoggable(LOG, Level.FINE);
    }

    private static boolean logFiner() {
        return Loggers.isLoggable(LOG, Level.FINER);
    }

    public static class CompressionRecord {
        public final BigIntegerRationalMatrix pre;
        public final BigIntegerRationalMatrix cmp;
        public final BigIntegerRationalMatrix post;
        public final boolean[] reversible;

        public CompressionRecord(BigIntegerRationalMatrix pre, BigIntegerRationalMatrix stoich, BigIntegerRationalMatrix post, boolean[] reversible) {
            this.pre = pre;
            this.cmp = stoich;
            this.post = post;
            this.reversible = reversible;
        }
    }

    private static class NullspaceRecord
    extends WorkRecord {
        final BigIntegerRationalMatrix reducedStoich;
        final BigIntegerRationalMatrix kernel;

        public NullspaceRecord(WorkRecord workRecord) {
            super(workRecord);
            BigIntegerRationalMatrix stoich = workRecord.cmp;
            Size size = workRecord.size;
            this.reducedStoich = stoich.getRowCount() == size.metas && stoich.getColumnCount() == size.reacs ? stoich : stoich.subBigIntegerRationalMatrix(0, size.metas, 0, size.reacs);
            this.kernel = new Gauss(0.0).nullspace(this.reducedStoich);
            if (Loggers.isLoggable(LOG, Level.FINEST)) {
                LogPrintWriter logWriter = new LogPrintWriter(LOG, Level.FINEST);
                LOG.finest("stoich matrix:");
                this.reducedStoich.writeToMultiline(logWriter);
                LOG.finest("kernel matrix:");
                this.kernel.writeToMultiline(logWriter);
            }
        }

        public void removeReaction(int reac) {
            super.removeReaction(reac);
            this.kernel.swapRows(reac, this.size.reacs);
        }
    }

    private static class Size
    implements Cloneable {
        int metas;
        int reacs;

        Size(int iMetas, int iReacs) {
            this.metas = iMetas;
            this.reacs = iReacs;
        }

        public String toString() {
            return "[metas=" + this.metas + ", reacs=" + this.reacs + "]";
        }

        public Size clone() {
            return new Size(this.metas, this.reacs);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other.getClass() == Size.class) {
                Size so = (Size)other;
                return this.metas == so.metas && this.reacs == so.reacs;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkRecord
    extends CompressionRecord {
        final CompressionStatistics stats;
        final String[] metaNames;
        final String[] reacNames;
        final Size size;

        WorkRecord(ReadableBigIntegerRationalMatrix rdStoich, boolean[] reversible, String[] metaNames, String[] reacNames) {
            super(StoichMatrixCompressor.identity(rdStoich.getRowCount()), StoichMatrixCompressor.cancel(rdStoich), StoichMatrixCompressor.identity(rdStoich.getColumnCount()), (boolean[])reversible.clone());
            this.stats = new CompressionStatistics();
            this.size = new Size(this.cmp.getRowCount(), this.cmp.getColumnCount());
            this.metaNames = metaNames;
            this.reacNames = reacNames;
        }

        WorkRecord(WorkRecord workRecord) {
            super(workRecord.pre, workRecord.cmp, workRecord.post, workRecord.reversible);
            this.stats = workRecord.stats;
            this.size = workRecord.size;
            this.metaNames = workRecord.metaNames;
            this.reacNames = workRecord.reacNames;
        }

        public CompressionRecord getTruncated() {
            BigIntegerRationalMatrix cmpTrunc = StoichMatrixCompressor.createSubStoich(this.pre, this.cmp, this.post, this.reversible, this.size);
            int m = this.cmp.getRowCount();
            int r = this.cmp.getColumnCount();
            int mc = cmpTrunc.getRowCount();
            int rc = cmpTrunc.getColumnCount();
            boolean[] revTrunc = new boolean[rc];
            System.arraycopy(this.reversible, 0, revTrunc, 0, rc);
            return new CompressionRecord(this.pre.subBigIntegerRationalMatrix(0, mc, 0, m), cmpTrunc, this.post.subBigIntegerRationalMatrix(0, r, 0, rc), revTrunc);
        }

        public void removeReaction(int reac) {
            int meta = 0;
            while (meta < this.size.metas) {
                this.cmp.setValueAt(meta, reac, BigFraction.ZERO);
                ++meta;
            }
            --this.size.reacs;
            if (reac != this.size.reacs) {
                this.post.swapColumns(reac, this.size.reacs);
                this.cmp.swapColumns(reac, this.size.reacs);
                Arrays.swap(this.reversible, reac, this.size.reacs);
                Arrays.swap(this.reacNames, reac, this.size.reacs);
            }
        }

        public boolean removeReactions(Set<String> suppressedReactions) {
            if (suppressedReactions == null || suppressedReactions.isEmpty()) {
                return false;
            }
            BitSet indexSet = new BitSet();
            for (String reac : suppressedReactions) {
                int index = -1;
                int i = 0;
                while (i < this.reacNames.length) {
                    if (this.reacNames[i].equals(reac)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index < 0) {
                    throw new IllegalArgumentException("no such reaction: " + reac);
                }
                indexSet.set(index);
            }
            this.removeReactions(indexSet);
            return true;
        }

        public void removeReactions(BitSet reactionsToRemove) {
            BitSet toRemove = (BitSet)reactionsToRemove.clone();
            int reac = toRemove.nextSetBit(0);
            while (reac >= 0) {
                this.removeReaction(reac);
                if (reac != this.size.reacs && toRemove.get(this.size.reacs)) {
                    toRemove.clear(this.size.reacs);
                    continue;
                }
                toRemove.clear(reac);
                reac = toRemove.nextSetBit(reac + 1);
            }
        }

        public void removeMetabolite(int meta, boolean setStoichToZero) {
            if (setStoichToZero) {
                int reac = 0;
                while (reac < this.size.reacs) {
                    this.cmp.setValueAt(meta, reac, BigFraction.ZERO);
                    ++reac;
                }
            }
            --this.size.metas;
            if (meta != this.size.metas) {
                this.pre.swapRows(meta, this.size.metas);
                this.cmp.swapRows(meta, this.size.metas);
                Arrays.swap(this.metaNames, meta, this.size.metas);
            }
        }

        public boolean removeUnusedMetabolites() {
            int origCnt = this.size.metas;
            StringBuilder sb = StoichMatrixCompressor.logFine() ? new StringBuilder() : null;
            int meta = 0;
            while (meta < this.size.metas) {
                boolean any = false;
                int reac = 0;
                while (reac < this.size.reacs && !any) {
                    any |= !StoichMatrixCompressor.isZero(this.cmp.getBigIntegerNumeratorAt(meta, reac));
                    ++reac;
                }
                if (!any) {
                    if (sb != null) {
                        if (sb.length() > 0) {
                            sb.append(" / ");
                        }
                        sb.append(this.metaNames[meta]);
                    }
                    this.removeMetabolite(meta, false);
                    this.stats.incUnusedMetabolite();
                    continue;
                }
                ++meta;
            }
            if (sb != null && sb.length() > 0) {
                LOG.fine("found and removed unused metabolites: " + sb);
            }
            return origCnt != this.size.metas;
        }

        public String getReactionNames(IntArray reacs) {
            return this.getReactionNames(new DefaultIntList(reacs));
        }

        public String getReactionNames(BitSet reacs) {
            return this.getReactionNames(new BitSetIntSet(reacs));
        }

        public String getReactionNames(IntIterable reacs) {
            StringBuilder sb = new StringBuilder();
            IntIterator it = reacs.iterator();
            while (it.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(" / ");
                }
                sb.append(this.reacNames[it.nextInt()]);
            }
            return sb.toString();
        }

        public String getReactionDetails(int reac) {
            ArrayList<1> ratios = new ArrayList<1>();
            int meta = 0;
            while (meta < this.size.metas) {
                BigFraction num = this.cmp.getBigFractionValueAt(meta, reac);
                if (num.signum() != 0) {
                    final String metaName = this.metaNames[meta];
                    ratios.add(new FractionNumberStoichMetabolicNetwork.AbstractBigIntegerMetaboliteRatio(reac, meta){

                        public Metabolite getMetabolite() {
                            return new DefaultMetabolite(metaName);
                        }

                        protected ReadableBigIntegerRationalMatrix getStoich() {
                            return WorkRecord.this.cmp;
                        }
                    });
                }
                ++meta;
            }
            return AbstractReaction.toString(ratios, this.reversible[reac]);
        }

        public void logReactionDetails(Level logLevel, String prefix, BitSet reacs) {
            if (Loggers.isLoggable(LOG, logLevel)) {
                this.logReactionDetails(logLevel, prefix, new BitSetIntSet(reacs));
            }
        }

        public void logReactionDetails(Level logLevel, String prefix, IntIterable reacs) {
            if (Loggers.isLoggable(LOG, logLevel)) {
                IntIterator it = reacs.iterator();
                while (it.hasNext()) {
                    int reac = it.nextInt();
                    this.logReactionDetails(logLevel, prefix, reac);
                }
            }
        }

        public void logReactionDetails(Level logLevel, String prefix, int reac) {
            if (Loggers.isLoggable(LOG, logLevel)) {
                LOG.log(logLevel, String.valueOf(prefix) + this.reacNames[reac] + " := " + this.getReactionDetails(reac));
            }
        }
    }
}

