/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.compress;

import ch.javasoft.math.BigFraction;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.compress.CompressionStatistics;
import ch.javasoft.metabolic.compress.LogPkg;
import ch.javasoft.metabolic.impl.AbstractReaction;
import ch.javasoft.metabolic.impl.DefaultMetabolite;
import ch.javasoft.metabolic.impl.FractionNumberStoichMetabolicNetwork;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.IntArray;
import ch.javasoft.util.ints.BitSetIntSet;
import ch.javasoft.util.ints.DefaultIntList;
import ch.javasoft.util.ints.IntIterable;
import ch.javasoft.util.ints.IntIterator;
import ch.javasoft.util.logging.Loggers;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DuplicateGeneCompressor {
    private static final Logger LOG = LogPkg.LOGGER;

    private DuplicateGeneCompressor() {
    }

    public static CompressionRecord compress(ReadableBigIntegerRationalMatrix stoich, boolean[] reversible, String[] metaNames, String[] reacNames, boolean extended) {
        WorkRecord workRecord = new WorkRecord(stoich, reversible, metaNames, reacNames);
        int itCount = workRecord.stats.incCompressionIteration();
        LOG.fine("compression iteration " + (itCount + 1) + " (duplicate genes)");
        DuplicateGeneCompressor.compressDuplicateGenes(workRecord, extended);
        workRecord.stats.writeToLog();
        return workRecord.getTruncated();
    }

    private static boolean compressDuplicateGenes(WorkRecord workRecord, boolean extended) {
        BigIntegerRationalMatrix stoich = workRecord.dupfree;
        boolean[] reversible = workRecord.reversible;
        Size size = workRecord.size;
        int metas = size.metas;
        int reacs = size.reacs;
        ArrayList<IntArray> groups = new ArrayList<IntArray>();
        BigFraction[] ratios = new BigFraction[reacs];
        int reacA = 0;
        while (reacA < reacs) {
            IntArray group = null;
            int reacB = reacA + 1;
            while (reacB < reacs) {
                BigFraction ratio = null;
                int meta = 0;
                while (meta < metas) {
                    boolean isZeroB;
                    boolean isZeroA = DuplicateGeneCompressor.isZero(stoich.getBigIntegerNumeratorAt(meta, reacA));
                    if (isZeroA != (isZeroB = DuplicateGeneCompressor.isZero(stoich.getBigIntegerNumeratorAt(meta, reacB)))) {
                        ratio = BigFraction.ZERO;
                        break;
                    }
                    if (!isZeroA) {
                        BigFraction valA = stoich.getBigFractionValueAt(meta, reacA);
                        BigFraction valB = stoich.getBigFractionValueAt(meta, reacB);
                        BigFraction curRatio = valA.divide(valB).reduce();
                        if (ratio == null) {
                            ratio = curRatio;
                        } else if (ratio.compareTo(curRatio) != 0) {
                            ratio = BigFraction.ZERO;
                            break;
                        }
                    }
                    ++meta;
                }
                if (ratio == null) {
                    LOG.warning("zero stoichiometries found: " + workRecord.getReactionNames(reacA, reacB));
                    workRecord.logReactionDetails(Level.WARNING, "  ", reacA);
                    workRecord.logReactionDetails(Level.WARNING, "  ", reacB);
                    throw new RuntimeException("no zero stoichiometries expected");
                }
                if (!DuplicateGeneCompressor.isZero(ratio.getNumerator())) {
                    ratios[reacB] = ratio;
                    if (group == null) {
                        group = new IntArray();
                        group.add(reacA);
                    }
                    group.add(reacB);
                }
                ++reacB;
            }
            if (group != null) {
                groups.add(group);
            }
            ++reacA;
        }
        BitSet toRemove = new BitSet();
        int iGrp = 0;
        while (iGrp < groups.size()) {
            IntArray grp = (IntArray)groups.get(iGrp);
            boolean keptRev = reversible[grp.first()];
            Boolean sameRev = keptRev;
            boolean scaled = false;
            int i = 1;
            while (i < grp.length()) {
                int reac = grp.get(i);
                keptRev |= reversible[reac] || ratios[reac].signum() < 0;
                scaled |= !ratios[reac].isOne();
                if (!sameRev.booleanValue() || !reversible[i] || !sameRev.booleanValue() && !reversible[i] && ratios[reac].signum() > 0) {
                    sameRev = null;
                    break;
                }
                ++i;
            }
            if (sameRev != null || extended) {
                if (scaled) {
                    LOG.info("found and removed duplicate gene reactions (some ratios unequal to one): " + workRecord.getReactionNames(grp));
                } else if (DuplicateGeneCompressor.logFine()) {
                    LOG.fine("found and removed duplicate gene reactions: " + workRecord.getReactionNames(grp));
                }
                int keptReac = grp.first();
                if (DuplicateGeneCompressor.logFiner()) {
                    String prefix = "   [+] r=1: ";
                    workRecord.logReactionDetails(Level.FINER, prefix, keptReac);
                }
                int i2 = 1;
                while (i2 < grp.length()) {
                    int reac = grp.get(i2);
                    if (DuplicateGeneCompressor.logFiner()) {
                        String prefix = "   [-] r=" + ratios[reac] + ": ";
                        workRecord.logReactionDetails(Level.FINER, prefix, reac);
                    }
                    toRemove.set(reac);
                    ++i2;
                }
                reversible[keptReac] = keptRev;
                workRecord.groups.add(grp);
                workRecord.stats.incDuplicateGeneReactions(grp.length());
            } else {
                LOG.finer("ignoring weak duplicate gene reactions (not all have same directionality): " + workRecord.getReactionNames(grp));
            }
            ++iGrp;
        }
        workRecord.removeReactions(toRemove);
        return !toRemove.isEmpty();
    }

    private static BigIntegerRationalMatrix cancel(ReadableBigIntegerRationalMatrix matrix) {
        BigIntegerRationalMatrix mx = matrix.toBigIntegerRationalMatrix(true);
        mx.reduce();
        return mx;
    }

    private static BigIntegerRationalMatrix identity(int size) {
        DefaultBigIntegerRationalMatrix id = new DefaultBigIntegerRationalMatrix(size, size);
        int piv = 0;
        while (piv < size) {
            id.setValueAt(piv, piv, BigFraction.ONE);
            ++piv;
        }
        return id;
    }

    private static BigIntegerRationalMatrix createSubStoich(ReadableBigIntegerRationalMatrix stoich, ReadableBigIntegerRationalMatrix post, boolean[] reversible, Size size) {
        return stoich.subBigIntegerRationalMatrix(0, size.metas, 0, size.reacs);
    }

    private static boolean isZero(BigInteger val) {
        return val.signum() == 0;
    }

    private static boolean logFine() {
        return Loggers.isLoggable(LOG, Level.FINE);
    }

    private static boolean logFiner() {
        return Loggers.isLoggable(LOG, Level.FINER);
    }

    public static class CompressionRecord {
        public final BigIntegerRationalMatrix dupelim;
        public final BigIntegerRationalMatrix dupfree;
        public final IntArray[] dupgroups;
        public final boolean[] reversible;
        public final String[] metaNames;
        public final String[] reacNames;

        public CompressionRecord(BigIntegerRationalMatrix stoich, BigIntegerRationalMatrix dupelim, IntArray[] dupgroups, boolean[] reversible, String[] metaNames, String[] reacNames) {
            this.dupfree = stoich;
            this.dupelim = dupelim;
            this.dupgroups = dupgroups;
            this.reversible = reversible;
            this.metaNames = metaNames;
            this.reacNames = reacNames;
        }
    }

    private static class Size
    implements Cloneable {
        int metas;
        int reacs;

        Size(int iMetas, int iReacs) {
            this.metas = iMetas;
            this.reacs = iReacs;
        }

        public String toString() {
            return "[metas=" + this.metas + ", reacs=" + this.reacs + "]";
        }

        public Size clone() {
            return new Size(this.metas, this.reacs);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other.getClass() == Size.class) {
                Size so = (Size)other;
                return this.metas == so.metas && this.reacs == so.reacs;
            }
            return false;
        }
    }

    private static class WorkRecord
    extends CompressionRecord {
        final CompressionStatistics stats = new CompressionStatistics();
        final Size size = new Size(this.dupfree.getRowCount(), this.dupfree.getColumnCount());
        final List<IntArray> groups = new ArrayList<IntArray>();

        WorkRecord(ReadableBigIntegerRationalMatrix rdStoich, boolean[] reversible, String[] metaNames, String[] reacNames) {
            super(DuplicateGeneCompressor.cancel(rdStoich), DuplicateGeneCompressor.identity(rdStoich.getColumnCount()), null, (boolean[])reversible.clone(), (String[])metaNames.clone(), (String[])reacNames.clone());
        }

        public CompressionRecord getTruncated() {
            BigIntegerRationalMatrix cmpTrunc = DuplicateGeneCompressor.createSubStoich(this.dupfree, this.dupelim, this.reversible, this.size);
            int r = this.dupfree.getColumnCount();
            int mc = cmpTrunc.getRowCount();
            int rc = cmpTrunc.getColumnCount();
            boolean[] revTrunc = new boolean[rc];
            String[] metaTrunc = new String[mc];
            String[] reacTrunc = new String[rc];
            System.arraycopy(this.reversible, 0, revTrunc, 0, rc);
            System.arraycopy(this.metaNames, 0, metaTrunc, 0, mc);
            System.arraycopy(this.reacNames, 0, reacTrunc, 0, rc);
            return new CompressionRecord(cmpTrunc, this.dupelim.subBigIntegerRationalMatrix(0, r, 0, rc), this.groups.toArray(new IntArray[this.groups.size()]), revTrunc, metaTrunc, reacTrunc);
        }

        public void removeReaction(int reac) {
            int meta = 0;
            while (meta < this.size.metas) {
                this.dupfree.setValueAt(meta, reac, BigFraction.ZERO);
                ++meta;
            }
            --this.size.reacs;
            if (reac != this.size.reacs) {
                this.dupelim.swapColumns(reac, this.size.reacs);
                this.dupfree.swapColumns(reac, this.size.reacs);
                Arrays.swap(this.reversible, reac, this.size.reacs);
                Arrays.swap(this.reacNames, reac, this.size.reacs);
            }
        }

        public void removeReactions(BitSet reactionsToRemove) {
            BitSet toRemove = (BitSet)reactionsToRemove.clone();
            int reac = toRemove.nextSetBit(0);
            while (reac >= 0) {
                this.removeReaction(reac);
                if (reac != this.size.reacs && toRemove.get(this.size.reacs)) {
                    toRemove.clear(this.size.reacs);
                    continue;
                }
                toRemove.clear(reac);
                reac = toRemove.nextSetBit(reac + 1);
            }
        }

        public String getReactionNames(IntArray reacs) {
            return this.getReactionNames(new DefaultIntList(reacs));
        }

        public String getReactionNames(int ... reacs) {
            BitSet bs = new BitSet();
            int i = 0;
            while (i < reacs.length) {
                bs.set(reacs[i]);
                ++i;
            }
            return this.getReactionNames(bs);
        }

        public String getReactionNames(BitSet reacs) {
            return this.getReactionNames(new BitSetIntSet(reacs));
        }

        public String getReactionNames(IntIterable reacs) {
            StringBuilder sb = new StringBuilder();
            IntIterator it = reacs.iterator();
            while (it.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(" / ");
                }
                sb.append(this.reacNames[it.nextInt()]);
            }
            return sb.toString();
        }

        public String getReactionDetails(int reac) {
            ArrayList<1> ratios = new ArrayList<1>();
            int meta = 0;
            while (meta < this.size.metas) {
                BigFraction num = this.dupfree.getBigFractionValueAt(meta, reac);
                if (num.signum() != 0) {
                    final String metaName = this.metaNames[meta];
                    ratios.add(new FractionNumberStoichMetabolicNetwork.AbstractBigIntegerMetaboliteRatio(reac, meta){

                        public Metabolite getMetabolite() {
                            return new DefaultMetabolite(metaName);
                        }

                        protected ReadableBigIntegerRationalMatrix getStoich() {
                            return WorkRecord.this.dupfree;
                        }
                    });
                }
                ++meta;
            }
            return AbstractReaction.toString(ratios, this.reversible[reac]);
        }

        public void logReactionDetails(Level logLevel, String prefix, BitSet reacs) {
            if (Loggers.isLoggable(LOG, logLevel)) {
                this.logReactionDetails(logLevel, prefix, new BitSetIntSet(reacs));
            }
        }

        public void logReactionDetails(Level logLevel, String prefix, IntIterable reacs) {
            if (Loggers.isLoggable(LOG, logLevel)) {
                IntIterator it = reacs.iterator();
                while (it.hasNext()) {
                    int reac = it.nextInt();
                    this.logReactionDetails(logLevel, prefix, reac);
                }
            }
        }

        public void logReactionDetails(Level logLevel, String prefix, int reac) {
            if (Loggers.isLoggable(LOG, logLevel)) {
                LOG.log(logLevel, String.valueOf(prefix) + this.reacNames[reac] + " := " + this.getReactionDetails(reac));
            }
        }
    }
}

