/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.varint;

import ch.javasoft.math.varint.VarInt;
import ch.javasoft.math.varint.VarIntFactory;
import ch.javasoft.math.varint.VarIntNumber;

public class VarIntUtil {
    public static VarIntNumber gcd(VarInt ... values) {
        if (values.length == 0) {
            return VarInt.ONE;
        }
        int allSgn = values[0].signum();
        VarInt gcd = values[0];
        int i = 1;
        while (i < values.length) {
            if (allSgn != values[i].signum()) {
                allSgn = 1;
            }
            if (gcd.isZero() || gcd.isOne()) break;
            if (!values[i].isZero()) {
                gcd = gcd.gcd(values[i]);
            }
            ++i;
        }
        if (allSgn == 0) {
            return VarInt.ZERO;
        }
        if (allSgn < 0) {
            return VarIntFactory.convert(gcd.negate());
        }
        return VarIntFactory.convert(gcd);
    }

    public static VarIntNumber lcm(VarInt ... values) {
        if (values.length == 0) {
            return VarInt.ONE;
        }
        VarInt lcm = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i].signum() != 0) {
                VarInt gcd = lcm.gcd(values[i]);
                if (gcd.isOne()) {
                    lcm = lcm.multiply(values[i]);
                } else if (!values[i].equals(gcd)) {
                    lcm = lcm.multiply(values[i].divide(gcd));
                }
            }
            ++i;
        }
        return VarIntFactory.convert(lcm);
    }

    private VarIntUtil() {
    }
}

