/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.ops;

import ch.javasoft.math.ops.AbstractNumberOps;
import ch.javasoft.util.numeric.IntegerUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerOperations
extends AbstractNumberOps<Integer> {
    private static IntegerOperations sInstance;

    public static IntegerOperations instance() {
        if (sInstance == null) {
            sInstance = new IntegerOperations();
        }
        return sInstance;
    }

    @Override
    public Class<Integer> numberClass() {
        return Integer.class;
    }

    @Override
    public Integer abs(Integer number) {
        return Math.abs(number);
    }

    @Override
    public Integer add(Integer numA, Integer numB) {
        return numA + numB;
    }

    public Integer[] newArray(int size) {
        return new Integer[size];
    }

    public Integer[][] newArray(int rows, int cols) {
        return new Integer[rows][cols];
    }

    @Override
    public Integer valueOf(String s) {
        return Integer.valueOf(s);
    }

    @Override
    public Integer valueOf(Number number) {
        if ((double)number.longValue() != number.doubleValue()) {
            throw new IllegalArgumentException("value not an integer value:  " + number);
        }
        return this.valueOf(number.longValue());
    }

    @Override
    public Integer valueOf(long value) {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("value out of integer range: " + value);
        }
        return (int)value;
    }

    @Override
    public Integer valueOf(double value) {
        int ivalue = (int)value;
        if ((double)ivalue != value) {
            throw new IllegalArgumentException("value not convertable to integer: " + value);
        }
        return ivalue;
    }

    @Override
    public Integer divide(Integer numA, Integer numB) {
        return numA / numB;
    }

    @Override
    public Integer invert(Integer number) {
        int val = number;
        if (val == 1 || val == -1) {
            return number;
        }
        throw new IllegalArgumentException("inversion would not yield an integer: " + val);
    }

    @Override
    public boolean isOne(Integer number) {
        return number == 1;
    }

    @Override
    public boolean isZero(Integer number) {
        return number == 0;
    }

    @Override
    public Integer multiply(Integer numA, Integer numB) {
        return numA * numB;
    }

    @Override
    public Integer negate(Integer number) {
        return -number.intValue();
    }

    @Override
    public Integer reduce(Integer number) {
        return number;
    }

    public Integer[] reduceVector(boolean cloneOnChange, Integer ... vector) {
        int gcd = Math.abs(IntegerUtil.gcd(vector));
        if (gcd != 0 && gcd != 1) {
            if (cloneOnChange) {
                vector = (Integer[])vector.clone();
            }
            int i = 0;
            while (i < vector.length) {
                vector[i] = vector[i] / gcd;
                ++i;
            }
        }
        return vector;
    }

    @Override
    public Integer one() {
        return 1;
    }

    @Override
    public Integer pow(Integer numA, Integer numB) {
        return (int)Math.pow(numA.intValue(), numB.intValue());
    }

    @Override
    public int signum(Integer number) {
        int val = number;
        return val < 0 ? -1 : (val > 0 ? 1 : 0);
    }

    @Override
    public Integer subtract(Integer numA, Integer numB) {
        return numA - numB;
    }

    @Override
    public Integer zero() {
        return 0;
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return o1.compareTo(o2);
    }

    @Override
    public byte[] toByteArray(Integer number) {
        int v = number;
        byte[] bytes = new byte[]{(byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return bytes;
    }

    @Override
    public void writeTo(Integer number, DataOutput out) throws IOException {
        out.writeInt(number);
    }

    @Override
    public Integer fromByteArray(byte[] bytes) {
        return (bytes[0] << 24) + (bytes[1] << 16) + (bytes[2] << 8) + (bytes[3] << 0);
    }

    @Override
    public Integer readFrom(DataInput in) throws IOException {
        return in.readInt();
    }

    @Override
    public int byteLength() {
        return 4;
    }
}

