/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array.impl;

import ch.javasoft.math.array.impl.AbstractArrayOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArrayOperations<C>
extends AbstractArrayOperations<C[]> {
    public DefaultArrayOperations(Class<C[]> arrayClass) {
        super(arrayClass);
    }

    @Override
    public int getLength(C[] array) {
        return array.length;
    }

    public int getColumnCount(C[][] matrix) {
        return matrix.length == 0 ? 0 : matrix[0].length;
    }

    @Override
    public String getAsString(C[] vector, int index) {
        return String.valueOf(vector[index]);
    }

    @Override
    public void swapVectorElements(C[] v, int index1, int index2) {
        C tmp = v[index1];
        v[index1] = v[index2];
        v[index2] = tmp;
    }

    public void swapMatrixElements(C[][] matrix, int row1, int col1, int row2, int col2) {
        C tmp = matrix[row1][col1];
        matrix[row1][col1] = matrix[row2][col2];
        matrix[row2][col2] = tmp;
    }

    public void swapMatrixRows(C[][] matrix, int row1, int row2) {
        int cols = this.getColumnCount(matrix);
        int c = 0;
        while (c < cols) {
            C tmp = matrix[row1][c];
            matrix[row1][c] = matrix[row2][c];
            matrix[row2][c] = tmp;
            ++c;
        }
    }

    public void swapMatrixColumns(C[][] matrix, int col1, int col2) {
        int rows = this.getRowCount((A[])matrix);
        int r = 0;
        while (r < rows) {
            C tmp = matrix[r][col1];
            matrix[r][col1] = matrix[r][col2];
            matrix[r][col2] = tmp;
            ++r;
        }
    }

    @Override
    public void swapVectorVectorElements(C[] v1, int index1, C[] v2, int index2) {
        C tmp = v1[index1];
        v1[index1] = v2[index2];
        v2[index2] = tmp;
    }

    public void swapVectorMatrixElements(C[] v, int index, C[][] m, int row, int col) {
        C tmp = v[index];
        v[index] = m[row][col];
        m[row][col] = tmp;
    }

    public void swapMatrixMatrixElements(C[][] m1, int row1, int col1, C[][] m2, int row2, int col2) {
        C tmp = m1[row1][col1];
        m1[row1][col1] = m2[row2][col2];
        m2[row2][col2] = tmp;
    }

    @Override
    public void copyVectorElement(C[] src, int srcIndex, C[] dst, int dstIndex) {
        dst[dstIndex] = src[srcIndex];
    }

    @Override
    public void copyVectorElements(C[] src, int[] srcIndices, C[] dst, int[] dstIndices) {
        if (srcIndices.length != dstIndices.length) {
            throw new IllegalArgumentException("size of source and destination indices must match: " + srcIndices.length + " != " + dstIndices.length);
        }
        int i = 0;
        while (i < srcIndices.length) {
            src[srcIndices[i]] = dst[dstIndices[i]];
            ++i;
        }
    }

    public void copyVectorElementsToMatrixColumn(C[] src, int srcStart, C[][] dst, int dstRowStart, int dstCol, int length) {
        int i = 0;
        while (i < length) {
            dst[dstRowStart + i][dstCol] = src[srcStart + i];
            ++i;
        }
    }

    public void copyMatrixElement(C[][] src, int srcRow, int srcCol, C[][] dst, int dstRow, int dstCol) {
        dst[dstRow][dstCol] = src[srcRow][srcCol];
    }

    public void copyMatrixRowElementsToColumn(C[][] src, int srcRow, int srcColStart, C[][] dst, int dstRowStart, int dstCol, int length) {
        int i = 0;
        while (i < length) {
            dst[dstRowStart + i][dstCol] = src[srcRow][srcColStart + i];
            ++i;
        }
    }

    public void copyMatrixColumnElements(C[][] src, int srcRowStart, int srcCol, C[][] dst, int dstRowStart, int dstCol, int length) {
        int i = 0;
        while (i < length) {
            dst[dstRowStart + i][dstCol] = src[srcRowStart + i][srcCol];
            ++i;
        }
    }

    public void copyMatrixColumnElementsToVector(C[][] src, int srcRowStart, int srcCol, C[] dst, int dstStart, int length) {
        int i = 0;
        while (i < length) {
            dst[dstStart + i] = src[srcRowStart + i][srcCol];
            ++i;
        }
    }

    public void copyMatrixColumnElementsToRow(C[][] src, int srcRowStart, int srcCol, C[][] dst, int dstRow, int dstColStart, int length) {
        int i = 0;
        while (i < length) {
            dst[dstRow][dstColStart + i] = src[srcRowStart + i][srcCol];
            ++i;
        }
    }

    public void copyVectorElementsToMatrixDiagonal(C[] src, C[][] dst) {
        int cols;
        int rows;
        int len = this.getLength(src);
        if (len != Math.min(rows = this.getRowCount((A[])dst), cols = this.getColumnCount(dst))) {
            throw new IllegalArgumentException("vector length must be equal to minimum dimension of matrix: " + len + " != min(" + rows + ", " + cols + ")");
        }
        int i = 0;
        while (i < len) {
            dst[i][i] = src[i];
            ++i;
        }
    }

    public void copyMatrixDiagonalElementsToVector(C[][] src, C[] dst) {
        int cols;
        int rows;
        int len = this.getLength(dst);
        if (len != Math.min(rows = this.getRowCount((A[])src), cols = this.getColumnCount(src))) {
            throw new IllegalArgumentException("vector length must be equal to minimum dimension of matrix: " + len + " != min(" + rows + ", " + cols + ")");
        }
        int i = 0;
        while (i < len) {
            dst[i] = src[i][i];
            ++i;
        }
    }

    public C[] copyOfMatrixDiagonal(C[][] matrix) {
        int rows = this.getRowCount((A[])matrix);
        int cols = this.getColumnCount(matrix);
        int len = Math.min(rows, cols);
        Object[] diag = (Object[])this.newVector(len);
        int i = 0;
        while (i < len) {
            diag[i] = matrix[i][i];
            ++i;
        }
        return diag;
    }

    public C[][] newDiagonalMatrix(C[] diagonal) {
        int len = diagonal.length;
        Object[][] matrix = (Object[][])this.newMatrix(len, len);
        int i = 0;
        while (i < len) {
            matrix[i][i] = diagonal[i];
            ++i;
        }
        return matrix;
    }

    public C[] copyOfMatrixColumn(C[][] matrix, int column) {
        int rows = this.getRowCount((A[])matrix);
        Object[] col = (Object[])this.newVector(rows);
        int r = 0;
        while (r < rows) {
            col[r] = matrix[r][column];
            ++r;
        }
        return col;
    }

    public C[] copyOfMatrixColumnRange(C[][] matrix, int rowFrom, int rowTo, int column) {
        int rows = rowTo - rowFrom;
        Object[] col = (Object[])this.newVector(rows);
        int r = 0;
        while (r < rows) {
            col[r] = matrix[rowFrom + r][column];
            ++r;
        }
        return col;
    }

    public C[][] copyOfColumnSubMatrix(C[][] matrix, int ... columnIndices) {
        if (columnIndices == null) {
            return (Object[][])this.copyOfMatrix((A[])matrix);
        }
        int rows = this.getRowCount((A[])matrix);
        int cols = columnIndices.length;
        Object[][] copy = (Object[][])this.newMatrix(rows, cols);
        int r = 0;
        while (r < rows) {
            int i = 0;
            while (i < cols) {
                copy[r][i] = matrix[r][columnIndices[i]];
                ++i;
            }
            ++r;
        }
        return copy;
    }

    public C[][] copyOfSubMatrix(C[][] matrix, int rowIndexFrom, int rowIndexTo, int colIndexFrom, int colIndexTo) {
        int rows = rowIndexTo - rowIndexFrom;
        int cols = colIndexTo - colIndexFrom;
        Object[][] copy = (Object[][])this.newMatrix(rows, cols);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                copy[i][j] = matrix[rowIndexFrom + i][colIndexFrom + j];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public C[][] copyOfSubMatrix(C[][] matrix, int[] rowIndices, int[] columnIndices) {
        if (rowIndices == null) {
            return this.copyOfColumnSubMatrix(matrix, columnIndices);
        }
        if (columnIndices == null) {
            return (Object[][])this.copyOfRowSubMatrix((A[])matrix, rowIndices);
        }
        int rows = rowIndices.length;
        int cols = columnIndices.length;
        Object[][] copy = (Object[][])this.newMatrix(rows, cols);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                copy[i][j] = matrix[rowIndices[i]][columnIndices[j]];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public C[][] transpose(C[][] matrix) {
        int rows = this.getRowCount((A[])matrix);
        int cols = this.getColumnCount(matrix);
        Object[][] trans = (Object[][])this.newMatrix(cols, rows);
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                trans[c][r] = matrix[r][c];
                ++c;
            }
            ++r;
        }
        return trans;
    }
}

