/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat.common;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MatType {
    UNKNOWN(0, 0),
    INT8(1, 1),
    UINT8(2, 1),
    INT16(3, 2),
    UINT16(4, 2),
    INT32(5, 4),
    UINT32(6, 4),
    SINGLE(7, 4),
    DOUBLE(9, 8),
    INT64(12, 8),
    UINT64(13, 8),
    MATRIX(14, 0),
    COMPRESSED(15, 0),
    UTF8(16, 1),
    UTF16(17, 2),
    UTF32(18, 4);

    public final int type;
    public final int size;

    private MatType(int type, int size) {
        this.type = type;
        this.size = size;
    }

    public static MatType getByType(int type) {
        MatType[] matTypeArray = MatType.values();
        int n = matTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MatType mt = matTypeArray[n2];
            if (mt.type == type) {
                return mt;
            }
            ++n2;
        }
        throw new IllegalArgumentException("no such mat type: " + type);
    }
}

