/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat;

import ch.javasoft.jsmat.MatWriter;
import ch.javasoft.jsmat.VariableWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatOutputStreamWriter
extends MatWriter<DataOutputStream> {
    private final OutputStream mOut;

    public MatOutputStreamWriter(OutputStream out) throws IOException {
        super(new DataOutputStream(out));
        this.mOut = out;
    }

    @Override
    protected void initDataOutput(DataOutputStream dataOutput) throws IOException {
    }

    @Override
    protected VariableWriter createVariableWriter() throws IOException {
        return new VariableWriter(){
            private ByteArrayOutputStream bout;
            private DeflaterOutputStream deflater;
            private DataOutputStream dataDefOut;

            public DataOutput open() throws IOException {
                this.bout = new ByteArrayOutputStream();
                this.deflater = new DeflaterOutputStream(this.bout);
                this.dataDefOut = new DataOutputStream(this.deflater);
                return this.dataDefOut;
            }

            public void close() throws IOException {
                this.dataDefOut.flush();
                this.deflater.finish();
                DataOutputStream dout = new DataOutputStream(MatOutputStreamWriter.this.mOut);
                dout.writeInt(15);
                dout.writeInt(this.bout.size());
                this.bout.writeTo(dout);
                this.bout.flush();
                dout.flush();
                this.bout = null;
                this.deflater = null;
                this.dataDefOut = null;
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.checkNoReservedWriter();
        this.mOut.close();
    }
}

