/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.job;

import ch.javasoft.job.AbstractJob;
import ch.javasoft.job.Executable;
import ch.javasoft.job.Job;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Executables<R> {
    public static <R> Executable<R> create(final Job<R> job) {
        return new AbstractJob<R>(){

            @Override
            public R run() throws Throwable {
                return job.run();
            }
        };
    }

    public static <R> Executable<R> create(Callable<R> callable) {
        return Executables.createAbstractJob(callable);
    }

    public static Executable<Void> create(Runnable runnable) {
        return Executables.createAbstractJob(runnable);
    }

    static <R> AbstractJob<R> createAbstractJob(final Callable<R> callable) {
        return new AbstractJob<R>(){

            @Override
            public R run() throws Throwable {
                return callable.call();
            }
        };
    }

    static AbstractJob<Void> createAbstractJob(final Runnable runnable) {
        return new AbstractJob<Void>(){

            @Override
            public Void run() throws Throwable {
                runnable.run();
                return null;
            }
        };
    }

    private Executables() {
    }
}

