/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase.concurrent;

import ch.javasoft.jbase.Table;
import ch.javasoft.jbase.util.UnsupportedOperationException;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexedAppendTable<E>
implements Table<E> {
    private final Table<E> baseTable;
    private final BlockingQueue<E> queue;
    private final CopyThread copyThread;
    private volatile boolean closed = false;

    public MultiplexedAppendTable(Table<E> baseTable) {
        this(baseTable, -1);
    }

    public MultiplexedAppendTable(Table<E> baseTable, int cacheSize) {
        this.baseTable = baseTable;
        this.queue = cacheSize <= 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(cacheSize);
        this.copyThread = new CopyThread();
        this.copyThread.start();
    }

    @Override
    public int add(E entity) throws IOException {
        if (this.closed) {
            throw new IOException("table closed");
        }
        try {
            this.queue.put(entity);
            return -1;
        }
        catch (InterruptedException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            return;
        }
        this.baseTable.flush();
    }

    @Override
    public void close(boolean erase) throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.copyThread.join();
        }
        catch (InterruptedException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        this.baseTable.close(erase);
    }

    @Override
    public E get(int index) throws IOException {
        throw new UnsupportedOperationException("unsupported by multiplexed append table");
    }

    @Override
    public void removeAll() throws IOException {
        throw new UnsupportedOperationException("unsupported by multiplexed append table");
    }

    @Override
    public void remove(int index) throws IOException {
        throw new UnsupportedOperationException("unsupported by multiplexed append table");
    }

    @Override
    public void set(int index, E entity) throws IOException {
        throw new UnsupportedOperationException("unsupported by multiplexed append table");
    }

    @Override
    public void swap(int indexA, int indexB) throws IOException {
        throw new UnsupportedOperationException("unsupported by multiplexed append table");
    }

    @Override
    public int size() throws IOException {
        throw new UnsupportedOperationException("unsupported by multiplexed append table");
    }

    private final class CopyThread
    extends Thread {
        private volatile boolean flush = false;

        private CopyThread() {
        }

        public void run() {
            try {
                while (!MultiplexedAppendTable.this.closed) {
                    Object next = MultiplexedAppendTable.this.queue.take();
                    MultiplexedAppendTable.this.baseTable.add(next);
                    if (!this.flush) continue;
                    Object entity = MultiplexedAppendTable.this.queue.poll();
                    while (entity != null) {
                        MultiplexedAppendTable.this.baseTable.add(entity);
                        entity = MultiplexedAppendTable.this.queue.poll();
                    }
                    MultiplexedAppendTable.this.baseTable.flush();
                    this.notifyAll();
                    this.flush = false;
                }
                Object entity = MultiplexedAppendTable.this.queue.poll();
                while (entity != null) {
                    MultiplexedAppendTable.this.baseTable.add(entity);
                    entity = MultiplexedAppendTable.this.queue.poll();
                }
                MultiplexedAppendTable.this.baseTable.flush();
            }
            catch (Exception e) {
                MultiplexedAppendTable.this.closed = true;
                throw new RuntimeException(e);
            }
        }
    }
}

