/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.bitset;

import ch.javasoft.bitset.BitSetFactory;
import ch.javasoft.bitset.IBitSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class LongBitSet
implements IBitSet {
    public static final LongBitSetFactory FACTORY = new LongBitSetFactory();
    private static final int BITS_PER_UNIT = 64;
    private long[] mUnits;

    public LongBitSet() {
        this(64);
    }

    public LongBitSet(int bitCapacity) {
        this.mUnits = new long[1 + (bitCapacity - 1) / 64];
    }

    public LongBitSet(BitSet bitSet) {
        this(bitSet.length());
        int bit = bitSet.nextSetBit(0);
        while (bit >= 0) {
            this.set(bit);
            bit = bitSet.nextSetBit(bit + 1);
        }
    }

    public LongBitSet(IBitSet bitSet) {
        this(bitSet.length());
        int bit = bitSet.nextSetBit(0);
        while (bit >= 0) {
            this.set(bit);
            bit = bitSet.nextSetBit(bit + 1);
        }
    }

    public LongBitSet(String bitString) {
        this(bitString.length());
        int ii = 0;
        while (ii < bitString.length()) {
            if (bitString.charAt(ii) == '1') {
                this.set(ii);
            }
            ++ii;
        }
    }

    public LongBitSet(long[] units, boolean cloneArray) {
        this.mUnits = cloneArray ? Arrays.copyOf(units, units.length) : units;
    }

    private void ensureCapacity(int unitLen) {
        if (this.mUnits.length < unitLen) {
            long[] newUnits = new long[unitLen];
            System.arraycopy(this.mUnits, 0, newUnits, 0, this.mUnits.length);
            this.mUnits = newUnits;
        }
    }

    public void set(int bit, boolean value) {
        if (value) {
            this.set(bit);
        } else {
            this.clear(bit);
        }
    }

    public void set(int bit) {
        int unit = bit / 64;
        int index = bit % 64;
        long mask = 1L << index;
        this.ensureCapacity(unit + 1);
        int n = unit;
        this.mUnits[n] = this.mUnits[n] | mask;
    }

    public void clear(int bit) {
        int unit = bit / 64;
        int index = bit % 64;
        long mask = 1L << index;
        int n = unit;
        this.mUnits[n] = this.mUnits[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear() {
        int ii = 0;
        while (ii < this.mUnits.length) {
            this.mUnits[ii] = 0L;
            ++ii;
        }
    }

    public void flip(int bit) {
        int unit = bit / 64;
        int index = bit % 64;
        long mask = 1L << index;
        this.ensureCapacity(unit + 1);
        int n = unit;
        this.mUnits[n] = this.mUnits[n] ^ this.mUnits[unit] & mask;
    }

    public boolean get(int bit) {
        int unit = bit / 64;
        if (unit >= this.mUnits.length) {
            return false;
        }
        int index = bit % 64;
        long mask = 1L << index;
        return 0L != (this.mUnits[unit] & mask);
    }

    public boolean isSubSetOf(IBitSet of) {
        return this.isSubSetOf(of instanceof LongBitSet ? (LongBitSet)of : new LongBitSet(of));
    }

    public boolean isSubSetOf(LongBitSet of) {
        if (this == of) {
            return true;
        }
        int min = Math.min(this.mUnits.length, of.mUnits.length);
        int ii = 0;
        while (ii < min) {
            long and = this.mUnits[ii] & of.mUnits[ii];
            if (and != this.mUnits[ii]) {
                return false;
            }
            ++ii;
        }
        int i = min;
        while (i < this.mUnits.length) {
            if (this.mUnits[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isSuperSetOfIntersection(IBitSet interA, IBitSet interB) {
        LongBitSet longA = interA instanceof LongBitSet ? (LongBitSet)interA : new LongBitSet(interA);
        LongBitSet longB = interB instanceof LongBitSet ? (LongBitSet)interB : new LongBitSet(interB);
        return this.isSuperSetOfIntersection(longA, longB);
    }

    public boolean isSuperSetOfIntersection(LongBitSet interA, LongBitSet interB) {
        if (this == interA || this == interB) {
            return true;
        }
        int minInter = Math.min(interA.mUnits.length, interB.mUnits.length);
        int minAll = Math.min(this.mUnits.length, minInter);
        int ii = 0;
        while (ii < minAll) {
            long inter = interA.mUnits[ii] & interB.mUnits[ii];
            if (inter != (inter & this.mUnits[ii])) {
                return false;
            }
            ++ii;
        }
        int i = minAll;
        while (i < minInter) {
            if (0L != (interA.mUnits[i] & interB.mUnits[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void and(IBitSet with) {
        this.and(with instanceof LongBitSet ? (LongBitSet)with : new LongBitSet(with));
    }

    public void and(LongBitSet with) {
        if (this == with) {
            return;
        }
        int len = Math.min(this.mUnits.length, with.mUnits.length);
        int ii = 0;
        while (ii < len) {
            int n = ii;
            this.mUnits[n] = this.mUnits[n] & with.mUnits[ii];
            ++ii;
        }
        ii = len;
        while (ii < this.mUnits.length) {
            this.mUnits[ii] = 0L;
            ++ii;
        }
    }

    public LongBitSet getAnd(IBitSet with) {
        return LongBitSet.getAnd(this, with instanceof LongBitSet ? (LongBitSet)with : new LongBitSet(with));
    }

    public LongBitSet getAnd(LongBitSet with) {
        return LongBitSet.getAnd(this, with);
    }

    public int getAndCardinality(IBitSet with) {
        return LongBitSet.getAndCardinality(this, with instanceof LongBitSet ? (LongBitSet)with : new LongBitSet(with));
    }

    public int getAndCardinality(LongBitSet with) {
        return LongBitSet.getAndCardinality(this, with);
    }

    public void or(IBitSet with) {
        this.or(with instanceof LongBitSet ? (LongBitSet)with : new LongBitSet(with));
    }

    public void or(LongBitSet with) {
        if (this == with) {
            return;
        }
        if (with.mUnits.length > this.mUnits.length) {
            long[] newUnits = new long[with.mUnits.length];
            int i = 0;
            while (i < this.mUnits.length) {
                newUnits[i] = this.mUnits[i] | with.mUnits[i];
                ++i;
            }
            i = this.mUnits.length;
            while (i < with.mUnits.length) {
                newUnits[i] = with.mUnits[i];
                ++i;
            }
            this.mUnits = newUnits;
        } else {
            int len = Math.min(this.mUnits.length, with.mUnits.length);
            int i = 0;
            while (i < len) {
                int n = i;
                this.mUnits[n] = this.mUnits[n] | with.mUnits[i];
                ++i;
            }
        }
    }

    public LongBitSet getOr(IBitSet with) {
        return LongBitSet.getOr(this, with instanceof LongBitSet ? (LongBitSet)with : new LongBitSet(with));
    }

    public LongBitSet getOr(LongBitSet with) {
        return LongBitSet.getOr(this, with);
    }

    public void xor(IBitSet with) {
        this.xor(with instanceof LongBitSet ? (LongBitSet)with : new LongBitSet(with));
    }

    public void xor(LongBitSet with) {
        int newlen = Math.max(this.mUnits.length, with.mUnits.length);
        if (this.mUnits.length == with.mUnits.length) {
            while (newlen > 0 && 0L == (this.mUnits[newlen - 1] ^ with.mUnits[newlen - 1])) {
                --newlen;
            }
        }
        if (newlen != this.mUnits.length) {
            long[] newUnits = new long[newlen];
            System.arraycopy(this.mUnits, 0, newUnits, 0, Math.min(newlen, this.mUnits.length));
            this.mUnits = newUnits;
        }
        int len = Math.min(with.mUnits.length, newlen);
        int i = 0;
        while (i < len) {
            int n = i;
            this.mUnits[n] = this.mUnits[n] ^ with.mUnits[i];
            ++i;
        }
    }

    public LongBitSet getXor(IBitSet with) {
        return LongBitSet.getXor(this, with instanceof LongBitSet ? (LongBitSet)with : new LongBitSet(with));
    }

    public LongBitSet getXor(LongBitSet with) {
        return LongBitSet.getXor(this, with);
    }

    public int getXorCardinality(IBitSet with) {
        return LongBitSet.getXorCardinality(this, with instanceof LongBitSet ? (LongBitSet)with : new LongBitSet(with));
    }

    public int getXorCardinality(LongBitSet with) {
        return LongBitSet.getXorCardinality(this, with);
    }

    public void andNot(IBitSet with) {
        this.andNot(with instanceof LongBitSet ? (LongBitSet)with : new LongBitSet(with));
    }

    public void andNot(LongBitSet with) {
        int len = Math.min(this.mUnits.length, with.mUnits.length);
        int i = 0;
        while (i < len) {
            int n = i;
            this.mUnits[n] = this.mUnits[n] & (with.mUnits[i] ^ 0xFFFFFFFFFFFFFFFFL);
            ++i;
        }
    }

    public LongBitSet getAndNot(IBitSet with) {
        return LongBitSet.getAndNot(this, with instanceof LongBitSet ? (LongBitSet)with : new LongBitSet(with));
    }

    public LongBitSet getAndNot(LongBitSet with) {
        return LongBitSet.getAndNot(this, with);
    }

    public static LongBitSet getXor(LongBitSet setA, LongBitSet setB) {
        LongBitSet res;
        if (setA.mUnits.length > setB.mUnits.length) {
            res = setA.clone();
            res.xor(setB);
        } else {
            res = setB.clone();
            res.xor(setA);
        }
        return res;
    }

    public static int getXorCardinality(LongBitSet setA, LongBitSet setB) {
        int card = 0;
        int minLen = Math.min(setA.mUnits.length, setB.mUnits.length);
        int i = 0;
        while (i < minLen) {
            card += Long.bitCount(setA.mUnits[i] ^ setB.mUnits[i]);
            ++i;
        }
        i = minLen;
        while (i < setA.mUnits.length) {
            card += Long.bitCount(setA.mUnits[i]);
            ++i;
        }
        i = minLen;
        while (i < setB.mUnits.length) {
            card += Long.bitCount(setB.mUnits[i]);
            ++i;
        }
        return card;
    }

    public static LongBitSet getOr(LongBitSet setA, LongBitSet setB) {
        LongBitSet smaller;
        LongBitSet larger;
        if (setA.mUnits.length >= setB.mUnits.length) {
            larger = setA;
            smaller = setB;
        } else {
            larger = setB;
            smaller = setA;
        }
        long[] units = new long[larger.mUnits.length];
        int i = 0;
        while (i < smaller.mUnits.length) {
            units[i] = smaller.mUnits[i] | larger.mUnits[i];
            ++i;
        }
        return new LongBitSet(units, false);
    }

    public static LongBitSet getAnd(LongBitSet setA, LongBitSet setB) {
        LongBitSet smaller;
        LongBitSet larger;
        if (setA.mUnits.length >= setB.mUnits.length) {
            larger = setA;
            smaller = setB;
        } else {
            larger = setB;
            smaller = setA;
        }
        long[] units = new long[smaller.mUnits.length];
        int i = 0;
        while (i < smaller.mUnits.length) {
            units[i] = smaller.mUnits[i] & larger.mUnits[i];
            ++i;
        }
        return new LongBitSet(units, false);
    }

    public static int getAndCardinality(LongBitSet setA, LongBitSet setB) {
        int card = 0;
        int minLen = Math.min(setA.mUnits.length, setB.mUnits.length);
        int i = 0;
        while (i < minLen) {
            card += Long.bitCount(setA.mUnits[i] & setB.mUnits[i]);
            ++i;
        }
        return card;
    }

    public static LongBitSet getAndNot(LongBitSet setA, LongBitSet setB) {
        long[] units = new long[setA.mUnits.length];
        int i = 0;
        while (i < setB.mUnits.length) {
            units[i] = setA.mUnits[i] & (setA.mUnits[i] ^ 0xFFFFFFFFFFFFFFFFL);
            ++i;
        }
        i = setB.mUnits.length;
        while (i < setA.mUnits.length) {
            units[i] = setA.mUnits[i];
            ++i;
        }
        return new LongBitSet(units, false);
    }

    public static LongBitSet getAnd(LongBitSet ... bitSets) {
        if (bitSets.length == 0) {
            return new LongBitSet();
        }
        if (bitSets.length == 1) {
            return bitSets[0].clone();
        }
        if (bitSets.length == 2) {
            return LongBitSet.getAnd(bitSets[0], bitSets[1]);
        }
        int smallest = 0;
        int i = 1;
        while (i < bitSets.length) {
            if (bitSets[i].length() < bitSets[smallest].length()) {
                smallest = i;
            }
            ++i;
        }
        LongBitSet result = bitSets[smallest].clone();
        int i2 = 0;
        while (i2 < bitSets.length) {
            if (i2 != smallest) {
                result.and(bitSets[i2]);
            }
            ++i2;
        }
        return result;
    }

    public int compareTo(IBitSet o) {
        return this.compareTo(o instanceof LongBitSet ? (LongBitSet)o : new LongBitSet(o));
    }

    public int compareTo(LongBitSet o) {
        int min = Math.min(this.mUnits.length, o.mUnits.length);
        int i = 0;
        while (i < min) {
            long revB;
            boolean bitB;
            boolean bitA = 0L != (1L & this.mUnits[i]);
            boolean bl = bitB = 0L != (1L & o.mUnits[i]);
            if (bitA != bitB) {
                return bitA ? 1 : -1;
            }
            long revA = Long.reverse(0xFFFFFFFFFFFFFFFEL & this.mUnits[i]);
            long cmp = revA - (revB = Long.reverse(0xFFFFFFFFFFFFFFFEL & o.mUnits[i]));
            if (cmp < 0L) {
                return -1;
            }
            if (cmp > 0L) {
                return 1;
            }
            ++i;
        }
        i = min;
        while (i < this.mUnits.length) {
            if (this.mUnits[i] != 0L) {
                return 1;
            }
            ++i;
        }
        i = min;
        while (i < o.mUnits.length) {
            if (this.mUnits[i] != 0L) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    protected int unitLength() {
        int index = this.mUnits.length;
        while (--index >= 0 && this.mUnits[index] == 0L) {
        }
        return index + 1;
    }

    public int length() {
        int index = this.mUnits.length;
        while (--index >= 0 && this.mUnits[index] == 0L) {
        }
        return index < 0 ? 0 : index * 64 + 64 - Long.numberOfLeadingZeros(this.mUnits[index]);
    }

    public boolean isEmpty() {
        int index = this.mUnits.length;
        while (--index >= 0 && this.mUnits[index] == 0L) {
        }
        return index < 0;
    }

    public LongBitSet clone() {
        return new LongBitSet((long[])this.mUnits.clone(), false);
    }

    public int cardinality() {
        int card = 0;
        int ii = 0;
        while (ii < this.mUnits.length) {
            card += Long.bitCount(this.mUnits[ii]);
            ++ii;
        }
        return card;
    }

    public int cardinality(int fromBit, int toBit) {
        int fromUnit = fromBit / 64;
        int toUnit = (toBit + 64 - 1) / 64;
        int unitStart = Math.max(0, fromUnit);
        int unitLen = Math.min(this.mUnits.length, toUnit);
        int card = 0;
        int ii = unitStart;
        while (ii < unitLen) {
            if (this.mUnits[ii] != 0L) {
                int bit;
                long unit = this.mUnits[ii];
                if (ii == fromUnit) {
                    bit = fromBit % 64;
                    unit &= -1L >>> bit;
                }
                if (ii == toUnit - 1) {
                    bit = fromBit % 64;
                    unit &= -1L << 64 - bit;
                }
                card += Long.bitCount(unit);
            }
            ++ii;
        }
        return card;
    }

    public int hashCode() {
        int code = 0;
        int ii = 0;
        while (ii < this.mUnits.length) {
            code = (int)((long)code ^ 0xFFFFFFFFL & this.mUnits[ii]);
            code = (int)((long)code ^ 0xFFFFFFFFL & this.mUnits[ii] >>> 32);
            ++ii;
        }
        return code;
    }

    public int hashCodeObj() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LongBitSet) {
            LongBitSet bitSet = (LongBitSet)obj;
            int len = Math.min(this.mUnits.length, bitSet.mUnits.length);
            int ii = 0;
            while (ii < len) {
                if (this.mUnits[ii] != bitSet.mUnits[ii]) {
                    return false;
                }
                ++ii;
            }
            ii = len;
            while (ii < this.mUnits.length) {
                if (this.mUnits[ii] != 0L) {
                    return false;
                }
                ++ii;
            }
            ii = len;
            while (ii < bitSet.mUnits.length) {
                if (bitSet.mUnits[ii] != 0L) {
                    return false;
                }
                ++ii;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int unitLen = this.unitLength();
        int ii = 0;
        while (ii < unitLen) {
            int len;
            int n = len = ii == unitLen - 1 ? 1 + (this.length() - 1) % 64 : 64;
            if (this.mUnits[ii] != 0L) {
                long bit = 1L;
                int jj = 0;
                while (jj < len) {
                    if ((this.mUnits[ii] & bit) != 0L) {
                        sb.append('1');
                    } else {
                        sb.append('0');
                    }
                    ++jj;
                    bit <<= 1;
                }
            } else {
                sb.append("0000000000000000000000000000000000000000000000000000000000000000", 0, len);
            }
            ++ii;
        }
        sb.append('}');
        return sb.toString();
    }

    public int nextSetBit(int from) {
        int fromBit = from % 64;
        int fromUnit = from / 64;
        int ii = Math.max(0, fromUnit);
        while (ii < this.mUnits.length) {
            if (this.mUnits[ii] != 0L) {
                long unit = this.mUnits[ii];
                if (ii == fromUnit) {
                    unit &= -1L << fromBit;
                }
                if (unit != 0L) {
                    return ii * 64 + Long.numberOfTrailingZeros(unit);
                }
            }
            ++ii;
        }
        return -1;
    }

    public int nextClearBit(int from) {
        int fromUnit;
        int fromBit = from % 64;
        int ii = fromUnit = from / 64;
        while (ii < this.mUnits.length) {
            if (this.mUnits[ii] != -1L) {
                long unit = this.mUnits[ii] ^ 0xFFFFFFFFFFFFFFFFL;
                if (ii == fromUnit) {
                    unit &= -1L << fromBit;
                }
                if (unit != 0L) {
                    return ii * 64 + Long.numberOfTrailingZeros(unit);
                }
            }
            ++ii;
        }
        return Math.max(from, this.length());
    }

    public BitSet toBitSet() {
        BitSet bitSet = new BitSet(this.length());
        int bit = this.nextSetBit(0);
        while (bit >= 0) {
            bitSet.set(bit);
            bit = this.nextSetBit(bit + 1);
        }
        return bitSet;
    }

    public void writeTo(OutputStream out) throws IOException {
        DataOutput dout = out instanceof DataOutput ? (DataOutput)((Object)out) : new DataOutputStream(out);
        dout.writeInt(this.mUnits.length);
        int i = 0;
        while (i < this.mUnits.length) {
            dout.writeLong(this.mUnits[i]);
            ++i;
        }
    }

    public static LongBitSet readFrom(InputStream in) throws IOException {
        DataInput din = in instanceof DataInput ? (DataInput)((Object)in) : new DataInputStream(in);
        int len = din.readInt();
        long[] units = new long[len];
        int i = 0;
        while (i < len) {
            units[i] = din.readLong();
            ++i;
        }
        return new LongBitSet(units, false);
    }

    public byte[] compress() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.compress(out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return out.toByteArray();
    }

    public void compress(OutputStream out) throws IOException {
        ZipOutputStream zOut = new ZipOutputStream(out);
        zOut.putNextEntry(new ZipEntry("A"));
        DataOutputStream dOut = new DataOutputStream(zOut);
        dOut.writeInt(this.mUnits.length);
        int ii = 0;
        while (ii < this.mUnits.length) {
            dOut.writeLong(this.mUnits[ii]);
            ++ii;
        }
        dOut.flush();
        zOut.closeEntry();
        zOut.flush();
    }

    public static LongBitSet uncompress(byte[] bytes) {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);
        try {
            return LongBitSet.uncompress(byteIn);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static LongBitSet uncompress(InputStream in) throws IOException {
        ZipInputStream zIn = new ZipInputStream(in);
        zIn.getNextEntry();
        DataInputStream dIn = new DataInputStream(zIn);
        int unitLen = dIn.readInt();
        long[] units = new long[unitLen];
        int ii = 0;
        while (ii < unitLen) {
            units[ii] = dIn.readLong();
            ++ii;
        }
        return new LongBitSet(units, false);
    }

    public BitSetFactory factory() {
        return FACTORY;
    }

    public long[] toLongArray() {
        return this.toLongArray(null, 0);
    }

    public long[] toLongArray(long[] arr, int offset) {
        int len = this.unitLength();
        if (arr == null || arr.length < len + offset) {
            arr = new long[len + offset];
        }
        System.arraycopy(this.mUnits, 0, arr, offset, len);
        return arr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LongBitSetFactory
    implements BitSetFactory {
        @Override
        public LongBitSet create() {
            return new LongBitSet();
        }

        @Override
        public LongBitSet create(int capacity) {
            return new LongBitSet(capacity);
        }

        @Override
        public LongBitSet create(IBitSet bits) {
            return new LongBitSet(bits);
        }

        @Override
        public LongBitSet convert(IBitSet bitSet) {
            return bitSet instanceof LongBitSet ? (LongBitSet)bitSet : new LongBitSet(bitSet);
        }

        @Override
        public LongBitSet create(BitSet bits) {
            return new LongBitSet(bits);
        }

        public Class<LongBitSet> getBitSetClass() {
            return LongBitSet.class;
        }
    }
}

