"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultUserPoolClientProps = exports.DefaultUserPoolProps = void 0;
const cognito = require("aws-cdk-lib/aws-cognito");
const aws_cdk_lib_1 = require("aws-cdk-lib");
function DefaultUserPoolProps() {
    const defaultUserPoolProps = {
        signInCaseSensitive: false,
        selfSignUpEnabled: true,
        passwordPolicy: {
            minLength: 12,
            requireDigits: true,
            requireLowercase: true,
            requireUppercase: true,
        },
        signInAliases: {
            email: true,
            phone: false,
            username: false,
            preferredUsername: false,
        },
    };
    return defaultUserPoolProps;
}
exports.DefaultUserPoolProps = DefaultUserPoolProps;
function DefaultUserPoolClientProps() {
    const defaultUserPoolClientProps = {
        oAuth: {
            flows: {
                authorizationCodeGrant: true
            },
            callbackUrls: ["http://localhost:8000/oauth2/token"],
            logoutUrls: ["http://localhost:8000/logged-out"],
            scopes: [cognito.OAuthScope.EMAIL, cognito.OAuthScope.OPENID]
        },
        idTokenValidity: aws_cdk_lib_1.Duration.hours(24),
        generateSecret: false
    };
    return defaultUserPoolClientProps;
}
exports.DefaultUserPoolClientProps = DefaultUserPoolClientProps;
//# sourceMappingURL=data:application/json;base64,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