import { CfnOutput,custom_resources } from 'aws-cdk-lib';
import  *  as cognito from 'aws-cdk-lib/aws-cognito'
import { Construct } from 'constructs'

/*
export function DefaultUserPoolProps(): cognito.UserPoolProps {

  const defaultUserPoolProps: cognito.UserPoolProps = {
    signInCaseSensitive: false,
    selfSignUpEnabled: true,
    passwordPolicy: {
        minLength:12,
        requireDigits:true,
        requireLowercase:true,
        requireUppercase:true,
    },
    signInAliases: {
        email:true,
        phone:false,
        username:false,
        preferredUsername:false,
    },
  };

  return defaultUserPoolProps;
}*/


export class TmUserPoolClient extends Construct {


    public userPool: cognito.UserPool;
    public userPoolClient: cognito.UserPoolClient;


    constructor(scope: Construct, id: string, userPoolProps:cognito.UserPoolProps,userPoolClientProps:any = {}) {
        super(scope, id);

        this.userPool = new cognito.UserPool(this,  `${id}-userpool`, userPoolProps)


        let lUserPoolClientProps:cognito.UserPoolClientProps = { 
            userPool:this.userPool,
            ...userPoolClientProps
        }
        //
        
        this.userPoolClient = new cognito.UserPoolClient(this, "UserPoolClient", lUserPoolClientProps)

        const describeCognitoUserPoolClient = new custom_resources.AwsCustomResource(
          this,
          'DescribeCognitoUserPoolClient',
          {
            resourceType: 'Custom::DescribeCognitoUserPoolClient',
            onCreate: {
              service: 'CognitoIdentityServiceProvider',
              action: 'describeUserPoolClient',
              parameters: {
                UserPoolId: this.userPool.userPoolId,
                ClientId: this.userPoolClient.userPoolClientId,
              },
              physicalResourceId: custom_resources.PhysicalResourceId.of(this.userPoolClient.userPoolClientId),
            },
            // TODO: can we restrict this policy more?
            policy: custom_resources.AwsCustomResourcePolicy.fromSdkCalls({
              resources: custom_resources.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
          }
        )
        const userPoolClientSecret = describeCognitoUserPoolClient.getResponseField(
          'UserPoolClient.ClientSecret'
        )

        new CfnOutput(this,"CognitoUserPoolId",{value:this.userPool.userPoolId,exportName:'CognitoUserPoolId'});

        new CfnOutput(this,"CognitoUserPoolClientId",{value:this.userPoolClient.userPoolClientId,exportName:'CognitoUserPoolClientId'});

        new CfnOutput(this,"CognitoUserPoolClientSecret",{value:userPoolClientSecret,exportName:'CognitoUserPoolClientSecret'});
    }
}

