# API Reference

**Classes**

Name|Description
----|-----------
[GitlabContainerRunner](#cdk-gitlab-runner-gitlabcontainerrunner)|*No description*


**Structs**

Name|Description
----|-----------
[GitlabContainerRunnerProps](#cdk-gitlab-runner-gitlabcontainerrunnerprops)|*No description*



## class GitlabContainerRunner 🔹 <a id="cdk-gitlab-runner-gitlabcontainerrunner"></a>



__Implements__: [IConstruct](#constructs-iconstruct), [IConstruct](#aws-cdk-core-iconstruct), [IConstruct](#constructs-iconstruct), [IDependable](#aws-cdk-core-idependable)
__Extends__: [Construct](#aws-cdk-core-construct)

### Initializer




```ts
new GitlabContainerRunner(scope: Construct, id: string, props: GitlabContainerRunnerProps)
```

* **scope** (<code>[Construct](#aws-cdk-core-construct)</code>)  *No description*
* **id** (<code>string</code>)  *No description*
* **props** (<code>[GitlabContainerRunnerProps](#cdk-gitlab-runner-gitlabcontainerrunnerprops)</code>)  *No description*
  * **gitlabtoken** (<code>string</code>)  Gitlab token for the Register Runner . 
  * **ec2iamrole** (<code>[IRole](#aws-cdk-aws-iam-irole)</code>)  IAM role for the Gitlab Runner Instance . __*Default*__: new Role for Gitlab Runner Instance , attach AmazonSSMManagedInstanceCore Policy .
  * **ec2type** (<code>string</code>)  Runner default EC2 instance type. __*Default*__: t3.micro
  * **gitlaburl** (<code>string</code>)  Gitlab Runner register url . __*Default*__: gitlaburl='https://gitlab.com/'
  * **selfvpc** (<code>[IVpc](#aws-cdk-aws-ec2-ivpc)</code>)  VPC for the Gitlab Runner . __*Default*__: new VPC will be created , 1 Vpc , 2 Public Subnet .
  * **tag1** (<code>string</code>)  Gitlab Runner register tag1  . __*Default*__: tag1: gitlab .
  * **tag2** (<code>string</code>)  Gitlab Runner register tag2  . __*Default*__: tag2: awscdk .
  * **tag3** (<code>string</code>)  Gitlab Runner register tag3  . __*Default*__: tag3: runner .



### Properties


Name | Type | Description 
-----|------|-------------
**runnerEc2**🔹 | <code>[IInstance](#aws-cdk-aws-ec2-iinstance)</code> | This represents a Runner EC2 instance .
**runnerRole**🔹 | <code>[IRole](#aws-cdk-aws-iam-irole)</code> | The IAM role assumed by the Runner instance .



## struct GitlabContainerRunnerProps 🔹 <a id="cdk-gitlab-runner-gitlabcontainerrunnerprops"></a>






Name | Type | Description 
-----|------|-------------
**gitlabtoken**🔹 | <code>string</code> | Gitlab token for the Register Runner .
**ec2iamrole**?🔹 | <code>[IRole](#aws-cdk-aws-iam-irole)</code> | IAM role for the Gitlab Runner Instance .<br/>__*Default*__: new Role for Gitlab Runner Instance , attach AmazonSSMManagedInstanceCore Policy .
**ec2type**?🔹 | <code>string</code> | Runner default EC2 instance type.<br/>__*Default*__: t3.micro
**gitlaburl**?🔹 | <code>string</code> | Gitlab Runner register url .<br/>__*Default*__: gitlaburl='https://gitlab.com/'
**selfvpc**?🔹 | <code>[IVpc](#aws-cdk-aws-ec2-ivpc)</code> | VPC for the Gitlab Runner .<br/>__*Default*__: new VPC will be created , 1 Vpc , 2 Public Subnet .
**tag1**?🔹 | <code>string</code> | Gitlab Runner register tag1  .<br/>__*Default*__: tag1: gitlab .
**tag2**?🔹 | <code>string</code> | Gitlab Runner register tag2  .<br/>__*Default*__: tag2: awscdk .
**tag3**?🔹 | <code>string</code> | Gitlab Runner register tag3  .<br/>__*Default*__: tag3: runner .



