# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from getopenpay.models.inline_subscription_item_update import InlineSubscriptionItemUpdate
from getopenpay.models.proration_enum import ProrationEnum
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class UpdateSubscriptionRequest(BaseModel):
    """
    UpdateSubscriptionRequest
    """ # noqa: E501
    payment_method_id: Optional[StrictStr] = None
    cancel_at_end: Optional[StrictBool] = None
    description: Optional[StrictStr] = None
    proration_behavior: Optional[ProrationEnum] = None
    trial_end: Optional[datetime] = None
    trial_period_days: Optional[StrictInt] = None
    coupon_id: Optional[StrictStr] = None
    promotion_code_id: Optional[StrictStr] = None
    items: Optional[List[InlineSubscriptionItemUpdate]] = None
    __properties: ClassVar[List[str]] = ["payment_method_id", "cancel_at_end", "description", "proration_behavior", "trial_end", "trial_period_days", "coupon_id", "promotion_code_id", "items"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of UpdateSubscriptionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item in self.items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['items'] = _items
        # set to None if payment_method_id (nullable) is None
        # and model_fields_set contains the field
        if self.payment_method_id is None and "payment_method_id" in self.model_fields_set:
            _dict['payment_method_id'] = None

        # set to None if cancel_at_end (nullable) is None
        # and model_fields_set contains the field
        if self.cancel_at_end is None and "cancel_at_end" in self.model_fields_set:
            _dict['cancel_at_end'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if trial_end (nullable) is None
        # and model_fields_set contains the field
        if self.trial_end is None and "trial_end" in self.model_fields_set:
            _dict['trial_end'] = None

        # set to None if trial_period_days (nullable) is None
        # and model_fields_set contains the field
        if self.trial_period_days is None and "trial_period_days" in self.model_fields_set:
            _dict['trial_period_days'] = None

        # set to None if coupon_id (nullable) is None
        # and model_fields_set contains the field
        if self.coupon_id is None and "coupon_id" in self.model_fields_set:
            _dict['coupon_id'] = None

        # set to None if promotion_code_id (nullable) is None
        # and model_fields_set contains the field
        if self.promotion_code_id is None and "promotion_code_id" in self.model_fields_set:
            _dict['promotion_code_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of UpdateSubscriptionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "payment_method_id": obj.get("payment_method_id"),
            "cancel_at_end": obj.get("cancel_at_end"),
            "description": obj.get("description"),
            "proration_behavior": obj.get("proration_behavior"),
            "trial_end": obj.get("trial_end"),
            "trial_period_days": obj.get("trial_period_days"),
            "coupon_id": obj.get("coupon_id"),
            "promotion_code_id": obj.get("promotion_code_id"),
            "items": [InlineSubscriptionItemUpdate.from_dict(_item) for _item in obj.get("items")] if obj.get("items") is not None else None
        })
        return _obj


