# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from getopenpay.models.proration_enum import ProrationEnum
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class UpdateSubscriptionItemRequest(BaseModel):
    """
    UpdateSubscriptionItemRequest
    """ # noqa: E501
    price_id: Optional[StrictStr] = None
    quantity: Optional[StrictInt] = None
    proration_behavior: Optional[ProrationEnum] = None
    drop_at_end: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["price_id", "quantity", "proration_behavior", "drop_at_end"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of UpdateSubscriptionItemRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if price_id (nullable) is None
        # and model_fields_set contains the field
        if self.price_id is None and "price_id" in self.model_fields_set:
            _dict['price_id'] = None

        # set to None if quantity (nullable) is None
        # and model_fields_set contains the field
        if self.quantity is None and "quantity" in self.model_fields_set:
            _dict['quantity'] = None

        # set to None if drop_at_end (nullable) is None
        # and model_fields_set contains the field
        if self.drop_at_end is None and "drop_at_end" in self.model_fields_set:
            _dict['drop_at_end'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of UpdateSubscriptionItemRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "price_id": obj.get("price_id"),
            "quantity": obj.get("quantity"),
            "proration_behavior": obj.get("proration_behavior"),
            "drop_at_end": obj.get("drop_at_end")
        })
        return _obj


