# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel, StrictBool, StrictFloat, StrictInt, StrictStr
from getopenpay.models.calendar_interval_enum import CalendarIntervalEnum
from getopenpay.models.price_tier_params import PriceTierParams
from getopenpay.models.price_type_enum import PriceTypeEnum
from getopenpay.models.pricing_model import PricingModel
from getopenpay.models.usage_agg_method_enum import UsageAggMethodEnum
from getopenpay.models.usage_type_enum import UsageTypeEnum
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class UpdatePriceRequest(BaseModel):
    """
    UpdatePriceRequest
    """ # noqa: E501
    is_active: Optional[StrictBool] = None
    internal_description: Optional[StrictStr] = None
    pricing_model: Optional[PricingModel] = None
    unit_amount_atom: Optional[StrictInt] = None
    transform_quantity_divide_by: Optional[Union[StrictFloat, StrictInt]] = None
    price_tiers: Optional[List[PriceTierParams]] = None
    price_type: Optional[PriceTypeEnum] = None
    billing_interval: Optional[CalendarIntervalEnum] = None
    billing_interval_count: Optional[StrictInt] = None
    contract_term_multiple: Optional[StrictInt] = None
    contract_auto_renew: Optional[StrictBool] = None
    trial_period_days: Optional[StrictInt] = None
    usage_type: Optional[UsageTypeEnum] = None
    aggregate_usage: Optional[UsageAggMethodEnum] = None
    default_net_d: Optional[StrictInt] = None
    can_only_be_purchased_with: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["is_active", "internal_description", "pricing_model", "unit_amount_atom", "transform_quantity_divide_by", "price_tiers", "price_type", "billing_interval", "billing_interval_count", "contract_term_multiple", "contract_auto_renew", "trial_period_days", "usage_type", "aggregate_usage", "default_net_d", "can_only_be_purchased_with"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of UpdatePriceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in price_tiers (list)
        _items = []
        if self.price_tiers:
            for _item in self.price_tiers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['price_tiers'] = _items
        # set to None if is_active (nullable) is None
        # and model_fields_set contains the field
        if self.is_active is None and "is_active" in self.model_fields_set:
            _dict['is_active'] = None

        # set to None if internal_description (nullable) is None
        # and model_fields_set contains the field
        if self.internal_description is None and "internal_description" in self.model_fields_set:
            _dict['internal_description'] = None

        # set to None if pricing_model (nullable) is None
        # and model_fields_set contains the field
        if self.pricing_model is None and "pricing_model" in self.model_fields_set:
            _dict['pricing_model'] = None

        # set to None if unit_amount_atom (nullable) is None
        # and model_fields_set contains the field
        if self.unit_amount_atom is None and "unit_amount_atom" in self.model_fields_set:
            _dict['unit_amount_atom'] = None

        # set to None if transform_quantity_divide_by (nullable) is None
        # and model_fields_set contains the field
        if self.transform_quantity_divide_by is None and "transform_quantity_divide_by" in self.model_fields_set:
            _dict['transform_quantity_divide_by'] = None

        # set to None if price_type (nullable) is None
        # and model_fields_set contains the field
        if self.price_type is None and "price_type" in self.model_fields_set:
            _dict['price_type'] = None

        # set to None if billing_interval (nullable) is None
        # and model_fields_set contains the field
        if self.billing_interval is None and "billing_interval" in self.model_fields_set:
            _dict['billing_interval'] = None

        # set to None if billing_interval_count (nullable) is None
        # and model_fields_set contains the field
        if self.billing_interval_count is None and "billing_interval_count" in self.model_fields_set:
            _dict['billing_interval_count'] = None

        # set to None if contract_term_multiple (nullable) is None
        # and model_fields_set contains the field
        if self.contract_term_multiple is None and "contract_term_multiple" in self.model_fields_set:
            _dict['contract_term_multiple'] = None

        # set to None if contract_auto_renew (nullable) is None
        # and model_fields_set contains the field
        if self.contract_auto_renew is None and "contract_auto_renew" in self.model_fields_set:
            _dict['contract_auto_renew'] = None

        # set to None if trial_period_days (nullable) is None
        # and model_fields_set contains the field
        if self.trial_period_days is None and "trial_period_days" in self.model_fields_set:
            _dict['trial_period_days'] = None

        # set to None if usage_type (nullable) is None
        # and model_fields_set contains the field
        if self.usage_type is None and "usage_type" in self.model_fields_set:
            _dict['usage_type'] = None

        # set to None if aggregate_usage (nullable) is None
        # and model_fields_set contains the field
        if self.aggregate_usage is None and "aggregate_usage" in self.model_fields_set:
            _dict['aggregate_usage'] = None

        # set to None if default_net_d (nullable) is None
        # and model_fields_set contains the field
        if self.default_net_d is None and "default_net_d" in self.model_fields_set:
            _dict['default_net_d'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of UpdatePriceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "is_active": obj.get("is_active"),
            "internal_description": obj.get("internal_description"),
            "pricing_model": obj.get("pricing_model"),
            "unit_amount_atom": obj.get("unit_amount_atom"),
            "transform_quantity_divide_by": obj.get("transform_quantity_divide_by"),
            "price_tiers": [PriceTierParams.from_dict(_item) for _item in obj.get("price_tiers")] if obj.get("price_tiers") is not None else None,
            "price_type": obj.get("price_type"),
            "billing_interval": obj.get("billing_interval"),
            "billing_interval_count": obj.get("billing_interval_count"),
            "contract_term_multiple": obj.get("contract_term_multiple"),
            "contract_auto_renew": obj.get("contract_auto_renew"),
            "trial_period_days": obj.get("trial_period_days"),
            "usage_type": obj.get("usage_type"),
            "aggregate_usage": obj.get("aggregate_usage"),
            "default_net_d": obj.get("default_net_d"),
            "can_only_be_purchased_with": obj.get("can_only_be_purchased_with")
        })
        return _obj


