# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictStr
from pydantic import Field
from getopenpay.models.object_name import ObjectName
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class TransitionEligibilityExternal(BaseModel):
    """
    TransitionEligibilityExternal
    """ # noqa: E501
    id: StrictStr = Field(description="Unique Identifier of the transition eligibility.")
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: StrictBool = Field(description="Flag to indicate whether the transition rule has been deleted or not")
    current_price_id: Optional[StrictStr]
    target_price_id: Optional[StrictStr]
    current_product_id: Optional[StrictStr]
    target_product_id: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "current_price_id", "target_price_id", "current_product_id", "target_product_id"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of TransitionEligibilityExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if current_price_id (nullable) is None
        # and model_fields_set contains the field
        if self.current_price_id is None and "current_price_id" in self.model_fields_set:
            _dict['current_price_id'] = None

        # set to None if target_price_id (nullable) is None
        # and model_fields_set contains the field
        if self.target_price_id is None and "target_price_id" in self.model_fields_set:
            _dict['target_price_id'] = None

        # set to None if current_product_id (nullable) is None
        # and model_fields_set contains the field
        if self.current_product_id is None and "current_product_id" in self.model_fields_set:
            _dict['current_product_id'] = None

        # set to None if target_product_id (nullable) is None
        # and model_fields_set contains the field
        if self.target_product_id is None and "target_product_id" in self.model_fields_set:
            _dict['target_product_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of TransitionEligibilityExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted"),
            "current_price_id": obj.get("current_price_id"),
            "target_price_id": obj.get("target_price_id"),
            "current_product_id": obj.get("current_product_id"),
            "target_product_id": obj.get("target_product_id")
        })
        return _obj


