# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from pydantic import Field
from getopenpay.models.credit_card_type import CreditCardType
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class TokenizedCreditCardInput(BaseModel):
    """
    TokenizedCreditCardInput
    """ # noqa: E501
    cde_external_id: StrictStr = Field(description="Card token.")
    last_four: StrictStr = Field(description="Last four digits of credit card")
    zip_code: StrictStr = Field(description="ZIP or postal code.")
    line1: Optional[StrictStr] = None
    line2: Optional[StrictStr] = None
    line3: Optional[StrictStr] = None
    city: Optional[StrictStr] = None
    state: Optional[StrictStr] = None
    country: Optional[StrictStr] = None
    card_type: Optional[CreditCardType] = None
    __properties: ClassVar[List[str]] = ["cde_external_id", "last_four", "zip_code", "line1", "line2", "line3", "city", "state", "country", "card_type"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of TokenizedCreditCardInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if line1 (nullable) is None
        # and model_fields_set contains the field
        if self.line1 is None and "line1" in self.model_fields_set:
            _dict['line1'] = None

        # set to None if line2 (nullable) is None
        # and model_fields_set contains the field
        if self.line2 is None and "line2" in self.model_fields_set:
            _dict['line2'] = None

        # set to None if line3 (nullable) is None
        # and model_fields_set contains the field
        if self.line3 is None and "line3" in self.model_fields_set:
            _dict['line3'] = None

        # set to None if city (nullable) is None
        # and model_fields_set contains the field
        if self.city is None and "city" in self.model_fields_set:
            _dict['city'] = None

        # set to None if state (nullable) is None
        # and model_fields_set contains the field
        if self.state is None and "state" in self.model_fields_set:
            _dict['state'] = None

        # set to None if country (nullable) is None
        # and model_fields_set contains the field
        if self.country is None and "country" in self.model_fields_set:
            _dict['country'] = None

        # set to None if card_type (nullable) is None
        # and model_fields_set contains the field
        if self.card_type is None and "card_type" in self.model_fields_set:
            _dict['card_type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of TokenizedCreditCardInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cde_external_id": obj.get("cde_external_id"),
            "last_four": obj.get("last_four"),
            "zip_code": obj.get("zip_code"),
            "line1": obj.get("line1"),
            "line2": obj.get("line2"),
            "line3": obj.get("line3"),
            "city": obj.get("city"),
            "state": obj.get("state"),
            "country": obj.get("country"),
            "card_type": obj.get("card_type")
        })
        return _obj


