# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.calendar_interval_enum import CalendarIntervalEnum
from getopenpay.models.discount_external import DiscountExternal
from getopenpay.models.object_name import ObjectName
from getopenpay.models.subscription_cancellation_details import SubscriptionCancellationDetails
from getopenpay.models.subscription_item_external import SubscriptionItemExternal
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class SubscriptionExternal(BaseModel):
    """
    SubscriptionExternal
    """ # noqa: E501
    id: StrictStr = Field(description="Unique Identifier of the subscription.")
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: Optional[StrictBool] = Field(default=False, description="If true, indicates that this object has been deleted")
    name: StrictStr = Field(description="Name for this subscription.")
    account_id: StrictStr = Field(description="Unique Identifier of the account.")
    customer_id: StrictStr = Field(description="Unique Identifier of the customer.")
    description: Optional[StrictStr]
    status: StrictStr = Field(description="Current status of the subscription.")
    initial_start: datetime = Field(description="Very beginning of the subscription, in 'ISO 8601' format.")
    current_period_start: datetime = Field(description="Starting of the current billing period, in 'ISO 8601' format.")
    current_period_end: datetime = Field(description="End of the current billing period, in 'ISO 8601' format.")
    default_payment_method_id: StrictStr = Field(description="Unique Identifier of the payment_method.")
    cancel_at_end: StrictBool = Field(description="Whether this subscription should cancel at the end of contract or billing cycle.")
    pause_at_end: Optional[StrictBool] = None
    pause_for_cycles: Optional[StrictInt] = None
    billing_interval: Optional[CalendarIntervalEnum] = None
    billing_interval_count: Optional[StrictInt] = None
    contract_start: Optional[datetime] = None
    contract_auto_renew: Optional[StrictBool] = None
    subscription_items: List[SubscriptionItemExternal]
    cancellation_details: Optional[SubscriptionCancellationDetails] = None
    trial_start: Optional[datetime] = None
    trial_end: Optional[datetime] = None
    discount: Optional[DiscountExternal] = None
    total_billing_cycles: Optional[StrictInt] = None
    remaining_billing_cycles: Optional[StrictInt] = None
    paused_at: Optional[datetime] = None
    resumes_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "name", "account_id", "customer_id", "description", "status", "initial_start", "current_period_start", "current_period_end", "default_payment_method_id", "cancel_at_end", "pause_at_end", "pause_for_cycles", "billing_interval", "billing_interval_count", "contract_start", "contract_auto_renew", "subscription_items", "cancellation_details", "trial_start", "trial_end", "discount", "total_billing_cycles", "remaining_billing_cycles", "paused_at", "resumes_at"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of SubscriptionExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in subscription_items (list)
        _items = []
        if self.subscription_items:
            for _item in self.subscription_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['subscription_items'] = _items
        # override the default output from pydantic by calling `to_dict()` of cancellation_details
        if self.cancellation_details:
            _dict['cancellation_details'] = self.cancellation_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of discount
        if self.discount:
            _dict['discount'] = self.discount.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if pause_at_end (nullable) is None
        # and model_fields_set contains the field
        if self.pause_at_end is None and "pause_at_end" in self.model_fields_set:
            _dict['pause_at_end'] = None

        # set to None if pause_for_cycles (nullable) is None
        # and model_fields_set contains the field
        if self.pause_for_cycles is None and "pause_for_cycles" in self.model_fields_set:
            _dict['pause_for_cycles'] = None

        # set to None if billing_interval (nullable) is None
        # and model_fields_set contains the field
        if self.billing_interval is None and "billing_interval" in self.model_fields_set:
            _dict['billing_interval'] = None

        # set to None if billing_interval_count (nullable) is None
        # and model_fields_set contains the field
        if self.billing_interval_count is None and "billing_interval_count" in self.model_fields_set:
            _dict['billing_interval_count'] = None

        # set to None if contract_start (nullable) is None
        # and model_fields_set contains the field
        if self.contract_start is None and "contract_start" in self.model_fields_set:
            _dict['contract_start'] = None

        # set to None if contract_auto_renew (nullable) is None
        # and model_fields_set contains the field
        if self.contract_auto_renew is None and "contract_auto_renew" in self.model_fields_set:
            _dict['contract_auto_renew'] = None

        # set to None if cancellation_details (nullable) is None
        # and model_fields_set contains the field
        if self.cancellation_details is None and "cancellation_details" in self.model_fields_set:
            _dict['cancellation_details'] = None

        # set to None if trial_start (nullable) is None
        # and model_fields_set contains the field
        if self.trial_start is None and "trial_start" in self.model_fields_set:
            _dict['trial_start'] = None

        # set to None if trial_end (nullable) is None
        # and model_fields_set contains the field
        if self.trial_end is None and "trial_end" in self.model_fields_set:
            _dict['trial_end'] = None

        # set to None if discount (nullable) is None
        # and model_fields_set contains the field
        if self.discount is None and "discount" in self.model_fields_set:
            _dict['discount'] = None

        # set to None if total_billing_cycles (nullable) is None
        # and model_fields_set contains the field
        if self.total_billing_cycles is None and "total_billing_cycles" in self.model_fields_set:
            _dict['total_billing_cycles'] = None

        # set to None if remaining_billing_cycles (nullable) is None
        # and model_fields_set contains the field
        if self.remaining_billing_cycles is None and "remaining_billing_cycles" in self.model_fields_set:
            _dict['remaining_billing_cycles'] = None

        # set to None if paused_at (nullable) is None
        # and model_fields_set contains the field
        if self.paused_at is None and "paused_at" in self.model_fields_set:
            _dict['paused_at'] = None

        # set to None if resumes_at (nullable) is None
        # and model_fields_set contains the field
        if self.resumes_at is None and "resumes_at" in self.model_fields_set:
            _dict['resumes_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of SubscriptionExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted") if obj.get("is_deleted") is not None else False,
            "name": obj.get("name"),
            "account_id": obj.get("account_id"),
            "customer_id": obj.get("customer_id"),
            "description": obj.get("description"),
            "status": obj.get("status"),
            "initial_start": obj.get("initial_start"),
            "current_period_start": obj.get("current_period_start"),
            "current_period_end": obj.get("current_period_end"),
            "default_payment_method_id": obj.get("default_payment_method_id"),
            "cancel_at_end": obj.get("cancel_at_end"),
            "pause_at_end": obj.get("pause_at_end"),
            "pause_for_cycles": obj.get("pause_for_cycles"),
            "billing_interval": obj.get("billing_interval"),
            "billing_interval_count": obj.get("billing_interval_count"),
            "contract_start": obj.get("contract_start"),
            "contract_auto_renew": obj.get("contract_auto_renew"),
            "subscription_items": [SubscriptionItemExternal.from_dict(_item) for _item in obj.get("subscription_items")] if obj.get("subscription_items") is not None else None,
            "cancellation_details": SubscriptionCancellationDetails.from_dict(obj.get("cancellation_details")) if obj.get("cancellation_details") is not None else None,
            "trial_start": obj.get("trial_start"),
            "trial_end": obj.get("trial_end"),
            "discount": DiscountExternal.from_dict(obj.get("discount")) if obj.get("discount") is not None else None,
            "total_billing_cycles": obj.get("total_billing_cycles"),
            "remaining_billing_cycles": obj.get("remaining_billing_cycles"),
            "paused_at": obj.get("paused_at"),
            "resumes_at": obj.get("resumes_at")
        })
        return _obj


