# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from pydantic import Field
from typing_extensions import Annotated
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class SearchChargeRequest(BaseModel):
    """
    SearchChargeRequest
    """ # noqa: E501
    page_number: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=1, description="Page number")
    page_size: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = Field(default=100, description="Page size")
    query: StrictStr = Field(description="The search query string in limited Lucene Query Syntax. Query is case insensitive.     Limitations:        1. You can combine multiple query clauses in a search by either separating them with a space, or using the AND or OR keywords (case insensitive). By default, the API combines clauses with AND logic. AND and OR operators are mutually exclusive.       2. Nesting of Queries by ( ) is not supported.     Example searches.       1. search by exact field. example: `name:'field_name'`       2. search by wildcard. example: `name:'*sub_string_1*'`, `name:'prefix_string*'`       3. range search using [], both bounds are included in result. example: `amount:[100 TO *]`, `amount:[10 TO 100]`.     ")
    __properties: ClassVar[List[str]] = ["page_number", "page_size", "query"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of SearchChargeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of SearchChargeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "page_number": obj.get("page_number") if obj.get("page_number") is not None else 1,
            "page_size": obj.get("page_size") if obj.get("page_size") is not None else 100,
            "query": obj.get("query")
        })
        return _obj


