# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt
from getopenpay.models.usage_agg_method_enum import UsageAggMethodEnum
from getopenpay.models.usage_type_enum import UsageTypeEnum
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class RecurringDetails(BaseModel):
    """
    RecurringDetails
    """ # noqa: E501
    usage_type: UsageTypeEnum
    aggregate_usage: Optional[UsageAggMethodEnum] = None
    trial_period_days: Optional[StrictInt] = 0
    __properties: ClassVar[List[str]] = ["usage_type", "aggregate_usage", "trial_period_days"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of RecurringDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if aggregate_usage (nullable) is None
        # and model_fields_set contains the field
        if self.aggregate_usage is None and "aggregate_usage" in self.model_fields_set:
            _dict['aggregate_usage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of RecurringDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "usage_type": obj.get("usage_type"),
            "aggregate_usage": obj.get("aggregate_usage"),
            "trial_period_days": obj.get("trial_period_days") if obj.get("trial_period_days") is not None else 0
        })
        return _obj


