# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.object_name import ObjectName
from getopenpay.models.promo_restrictions import PromoRestrictions
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class PromotionCodeExternal(BaseModel):
    """
    PromotionCodeExternal
    """ # noqa: E501
    id: StrictStr
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: Optional[StrictBool] = Field(default=False, description="If true, indicates that this object has been deleted")
    code: StrictStr
    is_active: StrictBool
    coupon_id: StrictStr
    customer_id: Optional[StrictStr]
    expires_at: Optional[datetime]
    max_redemptions: Optional[StrictInt]
    times_redeemed: Optional[StrictInt]
    restrictions: Optional[PromoRestrictions]
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "code", "is_active", "coupon_id", "customer_id", "expires_at", "max_redemptions", "times_redeemed", "restrictions"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of PromotionCodeExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of restrictions
        if self.restrictions:
            _dict['restrictions'] = self.restrictions.to_dict()
        # set to None if customer_id (nullable) is None
        # and model_fields_set contains the field
        if self.customer_id is None and "customer_id" in self.model_fields_set:
            _dict['customer_id'] = None

        # set to None if expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.expires_at is None and "expires_at" in self.model_fields_set:
            _dict['expires_at'] = None

        # set to None if max_redemptions (nullable) is None
        # and model_fields_set contains the field
        if self.max_redemptions is None and "max_redemptions" in self.model_fields_set:
            _dict['max_redemptions'] = None

        # set to None if times_redeemed (nullable) is None
        # and model_fields_set contains the field
        if self.times_redeemed is None and "times_redeemed" in self.model_fields_set:
            _dict['times_redeemed'] = None

        # set to None if restrictions (nullable) is None
        # and model_fields_set contains the field
        if self.restrictions is None and "restrictions" in self.model_fields_set:
            _dict['restrictions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of PromotionCodeExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted") if obj.get("is_deleted") is not None else False,
            "code": obj.get("code"),
            "is_active": obj.get("is_active"),
            "coupon_id": obj.get("coupon_id"),
            "customer_id": obj.get("customer_id"),
            "expires_at": obj.get("expires_at"),
            "max_redemptions": obj.get("max_redemptions"),
            "times_redeemed": obj.get("times_redeemed"),
            "restrictions": PromoRestrictions.from_dict(obj.get("restrictions")) if obj.get("restrictions") is not None else None
        })
        return _obj


