# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictStr
from pydantic import Field
from typing_extensions import Annotated
from getopenpay.models.date_time_filter import DateTimeFilter
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class PromoCodeQueryParams(BaseModel):
    """
    PromoCodeQueryParams
    """ # noqa: E501
    page_number: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=1, description="Page number")
    page_size: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = Field(default=100, description="Page size")
    sort_key: Optional[StrictStr] = Field(default='created_at', description="Key name based on which data is sorted.")
    sort_descending: Optional[StrictBool] = Field(default=False, description="Sort direction.")
    created_at: Optional[DateTimeFilter] = None
    expand: Optional[List[StrictStr]] = None
    coupon_id: Optional[StrictStr] = None
    customer_id: Optional[StrictStr] = None
    is_active: Optional[StrictBool] = None
    code: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["page_number", "page_size", "sort_key", "sort_descending", "created_at", "expand", "coupon_id", "customer_id", "is_active", "code"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of PromoCodeQueryParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_at
        if self.created_at:
            _dict['created_at'] = self.created_at.to_dict()
        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if coupon_id (nullable) is None
        # and model_fields_set contains the field
        if self.coupon_id is None and "coupon_id" in self.model_fields_set:
            _dict['coupon_id'] = None

        # set to None if customer_id (nullable) is None
        # and model_fields_set contains the field
        if self.customer_id is None and "customer_id" in self.model_fields_set:
            _dict['customer_id'] = None

        # set to None if is_active (nullable) is None
        # and model_fields_set contains the field
        if self.is_active is None and "is_active" in self.model_fields_set:
            _dict['is_active'] = None

        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of PromoCodeQueryParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "page_number": obj.get("page_number") if obj.get("page_number") is not None else 1,
            "page_size": obj.get("page_size") if obj.get("page_size") is not None else 100,
            "sort_key": obj.get("sort_key") if obj.get("sort_key") is not None else 'created_at',
            "sort_descending": obj.get("sort_descending") if obj.get("sort_descending") is not None else False,
            "created_at": DateTimeFilter.from_dict(obj.get("created_at")) if obj.get("created_at") is not None else None,
            "expand": obj.get("expand"),
            "coupon_id": obj.get("coupon_id"),
            "customer_id": obj.get("customer_id"),
            "is_active": obj.get("is_active"),
            "code": obj.get("code")
        })
        return _obj


