# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.object_name import ObjectName
from getopenpay.models.price_external import PriceExternal
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class ProductExternal(BaseModel):
    """
    ProductExternal
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier of the product.")
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: Optional[StrictBool] = Field(default=False, description="If true, indicates that this object has been deleted")
    name: StrictStr = Field(description="Name of product.")
    description: Optional[StrictStr]
    features: List[StrictStr]
    default_price: Optional[StrictInt]
    is_active: StrictBool = Field(description="Whether the product is currently available for purchase.")
    prices: List[PriceExternal]
    account_sku: Optional[StrictStr]
    unit_label: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "name", "description", "features", "default_price", "is_active", "prices", "account_sku", "unit_label"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ProductExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in prices (list)
        _items = []
        if self.prices:
            for _item in self.prices:
                if _item:
                    _items.append(_item.to_dict())
            _dict['prices'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if default_price (nullable) is None
        # and model_fields_set contains the field
        if self.default_price is None and "default_price" in self.model_fields_set:
            _dict['default_price'] = None

        # set to None if account_sku (nullable) is None
        # and model_fields_set contains the field
        if self.account_sku is None and "account_sku" in self.model_fields_set:
            _dict['account_sku'] = None

        # set to None if unit_label (nullable) is None
        # and model_fields_set contains the field
        if self.unit_label is None and "unit_label" in self.model_fields_set:
            _dict['unit_label'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of ProductExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted") if obj.get("is_deleted") is not None else False,
            "name": obj.get("name"),
            "description": obj.get("description"),
            "features": obj.get("features"),
            "default_price": obj.get("default_price"),
            "is_active": obj.get("is_active"),
            "prices": [PriceExternal.from_dict(_item) for _item in obj.get("prices")] if obj.get("prices") is not None else None,
            "account_sku": obj.get("account_sku"),
            "unit_label": obj.get("unit_label")
        })
        return _obj


