# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class PriceTierParams(BaseModel):
    """
    PriceTierParams
    """ # noqa: E501
    units_from: StrictInt = Field(description="The starting unit for the price tier.")
    units_upto: Optional[StrictInt] = None
    unit_amount_atom: StrictInt = Field(description="The price for the unit in the smallest denomination.It is in atomic units (in USD this is cents).")
    flat_amount_atom: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["units_from", "units_upto", "unit_amount_atom", "flat_amount_atom"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of PriceTierParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if units_upto (nullable) is None
        # and model_fields_set contains the field
        if self.units_upto is None and "units_upto" in self.model_fields_set:
            _dict['units_upto'] = None

        # set to None if flat_amount_atom (nullable) is None
        # and model_fields_set contains the field
        if self.flat_amount_atom is None and "flat_amount_atom" in self.model_fields_set:
            _dict['flat_amount_atom'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of PriceTierParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "units_from": obj.get("units_from"),
            "units_upto": obj.get("units_upto"),
            "unit_amount_atom": obj.get("unit_amount_atom"),
            "flat_amount_atom": obj.get("flat_amount_atom")
        })
        return _obj


