# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel, StrictBool, StrictFloat, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.billing_scheme_enum import BillingSchemeEnum
from getopenpay.models.calendar_interval_enum import CalendarIntervalEnum
from getopenpay.models.invoice_settings import InvoiceSettings
from getopenpay.models.object_name import ObjectName
from getopenpay.models.price_tier_external import PriceTierExternal
from getopenpay.models.price_type_enum import PriceTypeEnum
from getopenpay.models.pricing_tiers_enum import PricingTiersEnum
from getopenpay.models.recurring_details import RecurringDetails
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class PriceExternal(BaseModel):
    """
    PriceExternal
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier of the price.")
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: Optional[StrictBool] = Field(default=False, description="If true, indicates that this object has been deleted")
    is_active: StrictBool = Field(description="Whether the price can be used for new purchases. Price can be activated later.")
    product_id: StrictStr = Field(description="Unique identifier of the product.")
    internal_description: Optional[StrictStr]
    billing_scheme: BillingSchemeEnum
    unit_amount_atom: Optional[StrictInt]
    transform_quantity_divide_by: Union[StrictFloat, StrictInt] = Field(description="This transformation will be applied on quantity before mulitplying by 'unit_amount_atom'.")
    price_tiers: List[PriceTierExternal]
    price_type: PriceTypeEnum
    recurring_details: Optional[RecurringDetails]
    tiers_mode: Optional[PricingTiersEnum]
    billing_interval: Optional[CalendarIntervalEnum]
    billing_interval_count: Optional[StrictInt]
    contract_term_multiple: Optional[StrictInt]
    contract_auto_renew: Optional[StrictBool]
    invoice_settings: Optional[InvoiceSettings]
    is_licensed: StrictBool = Field(description="Whether the price is licensed or not.")
    is_exclusive: Optional[StrictBool] = Field(default=False, description="Whether the price is exclusive or not.")
    listed_exclusively_for_customers: List[StrictStr]
    can_only_be_purchased_with: List[StrictStr]
    optional_add_ons: List[StrictStr]
    eligible_for_updates: StrictBool = Field(description="If the price can be updated or not.")
    currency: StrictStr
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "is_active", "product_id", "internal_description", "billing_scheme", "unit_amount_atom", "transform_quantity_divide_by", "price_tiers", "price_type", "recurring_details", "tiers_mode", "billing_interval", "billing_interval_count", "contract_term_multiple", "contract_auto_renew", "invoice_settings", "is_licensed", "is_exclusive", "listed_exclusively_for_customers", "can_only_be_purchased_with", "optional_add_ons", "eligible_for_updates", "currency"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of PriceExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in price_tiers (list)
        _items = []
        if self.price_tiers:
            for _item in self.price_tiers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['price_tiers'] = _items
        # override the default output from pydantic by calling `to_dict()` of recurring_details
        if self.recurring_details:
            _dict['recurring_details'] = self.recurring_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of invoice_settings
        if self.invoice_settings:
            _dict['invoice_settings'] = self.invoice_settings.to_dict()
        # set to None if internal_description (nullable) is None
        # and model_fields_set contains the field
        if self.internal_description is None and "internal_description" in self.model_fields_set:
            _dict['internal_description'] = None

        # set to None if unit_amount_atom (nullable) is None
        # and model_fields_set contains the field
        if self.unit_amount_atom is None and "unit_amount_atom" in self.model_fields_set:
            _dict['unit_amount_atom'] = None

        # set to None if recurring_details (nullable) is None
        # and model_fields_set contains the field
        if self.recurring_details is None and "recurring_details" in self.model_fields_set:
            _dict['recurring_details'] = None

        # set to None if tiers_mode (nullable) is None
        # and model_fields_set contains the field
        if self.tiers_mode is None and "tiers_mode" in self.model_fields_set:
            _dict['tiers_mode'] = None

        # set to None if billing_interval (nullable) is None
        # and model_fields_set contains the field
        if self.billing_interval is None and "billing_interval" in self.model_fields_set:
            _dict['billing_interval'] = None

        # set to None if billing_interval_count (nullable) is None
        # and model_fields_set contains the field
        if self.billing_interval_count is None and "billing_interval_count" in self.model_fields_set:
            _dict['billing_interval_count'] = None

        # set to None if contract_term_multiple (nullable) is None
        # and model_fields_set contains the field
        if self.contract_term_multiple is None and "contract_term_multiple" in self.model_fields_set:
            _dict['contract_term_multiple'] = None

        # set to None if contract_auto_renew (nullable) is None
        # and model_fields_set contains the field
        if self.contract_auto_renew is None and "contract_auto_renew" in self.model_fields_set:
            _dict['contract_auto_renew'] = None

        # set to None if invoice_settings (nullable) is None
        # and model_fields_set contains the field
        if self.invoice_settings is None and "invoice_settings" in self.model_fields_set:
            _dict['invoice_settings'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of PriceExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted") if obj.get("is_deleted") is not None else False,
            "is_active": obj.get("is_active"),
            "product_id": obj.get("product_id"),
            "internal_description": obj.get("internal_description"),
            "billing_scheme": obj.get("billing_scheme"),
            "unit_amount_atom": obj.get("unit_amount_atom"),
            "transform_quantity_divide_by": obj.get("transform_quantity_divide_by"),
            "price_tiers": [PriceTierExternal.from_dict(_item) for _item in obj.get("price_tiers")] if obj.get("price_tiers") is not None else None,
            "price_type": obj.get("price_type"),
            "recurring_details": RecurringDetails.from_dict(obj.get("recurring_details")) if obj.get("recurring_details") is not None else None,
            "tiers_mode": obj.get("tiers_mode"),
            "billing_interval": obj.get("billing_interval"),
            "billing_interval_count": obj.get("billing_interval_count"),
            "contract_term_multiple": obj.get("contract_term_multiple"),
            "contract_auto_renew": obj.get("contract_auto_renew"),
            "invoice_settings": InvoiceSettings.from_dict(obj.get("invoice_settings")) if obj.get("invoice_settings") is not None else None,
            "is_licensed": obj.get("is_licensed"),
            "is_exclusive": obj.get("is_exclusive") if obj.get("is_exclusive") is not None else False,
            "listed_exclusively_for_customers": obj.get("listed_exclusively_for_customers"),
            "can_only_be_purchased_with": obj.get("can_only_be_purchased_with"),
            "optional_add_ons": obj.get("optional_add_ons"),
            "eligible_for_updates": obj.get("eligible_for_updates"),
            "currency": obj.get("currency")
        })
        return _obj


