# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictStr
from pydantic import Field
from getopenpay.models.complete_address import CompleteAddress
from getopenpay.models.credit_card_type import CreditCardType
from getopenpay.models.object_name import ObjectName
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class PaymentMethodExternal(BaseModel):
    """
    PaymentMethodExternal
    """ # noqa: E501
    id: StrictStr = Field(description="Unique Identifier of the payment_method.")
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: Optional[StrictBool] = Field(default=False, description="If true, indicates that this object has been deleted")
    card_type: Optional[CreditCardType]
    last_four: Optional[StrictStr]
    billing_address: Optional[CompleteAddress]
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "card_type", "last_four", "billing_address"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of PaymentMethodExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of billing_address
        if self.billing_address:
            _dict['billing_address'] = self.billing_address.to_dict()
        # set to None if card_type (nullable) is None
        # and model_fields_set contains the field
        if self.card_type is None and "card_type" in self.model_fields_set:
            _dict['card_type'] = None

        # set to None if last_four (nullable) is None
        # and model_fields_set contains the field
        if self.last_four is None and "last_four" in self.model_fields_set:
            _dict['last_four'] = None

        # set to None if billing_address (nullable) is None
        # and model_fields_set contains the field
        if self.billing_address is None and "billing_address" in self.model_fields_set:
            _dict['billing_address'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of PaymentMethodExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted") if obj.get("is_deleted") is not None else False,
            "card_type": obj.get("card_type"),
            "last_four": obj.get("last_four"),
            "billing_address": CompleteAddress.from_dict(obj.get("billing_address")) if obj.get("billing_address") is not None else None
        })
        return _obj


