# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.object_name import ObjectName
from getopenpay.models.payment_intent_status import PaymentIntentStatus
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class PaymentIntentExternal(BaseModel):
    """
    PaymentIntentExternal
    """ # noqa: E501
    id: StrictStr
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: Optional[StrictBool] = Field(default=False, description="If true, indicates that this object has been deleted")
    amount_atom: StrictInt
    amount_atom_capturable: Optional[StrictInt]
    amount_atom_received: Optional[StrictInt]
    currency: StrictStr
    customer_id: StrictStr
    payment_method_id: Optional[StrictStr]
    status: PaymentIntentStatus
    invoice_id: Optional[StrictStr]
    charge_ids: List[StrictStr]
    refund_ids: List[StrictStr]
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "amount_atom", "amount_atom_capturable", "amount_atom_received", "currency", "customer_id", "payment_method_id", "status", "invoice_id", "charge_ids", "refund_ids"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of PaymentIntentExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if amount_atom_capturable (nullable) is None
        # and model_fields_set contains the field
        if self.amount_atom_capturable is None and "amount_atom_capturable" in self.model_fields_set:
            _dict['amount_atom_capturable'] = None

        # set to None if amount_atom_received (nullable) is None
        # and model_fields_set contains the field
        if self.amount_atom_received is None and "amount_atom_received" in self.model_fields_set:
            _dict['amount_atom_received'] = None

        # set to None if payment_method_id (nullable) is None
        # and model_fields_set contains the field
        if self.payment_method_id is None and "payment_method_id" in self.model_fields_set:
            _dict['payment_method_id'] = None

        # set to None if invoice_id (nullable) is None
        # and model_fields_set contains the field
        if self.invoice_id is None and "invoice_id" in self.model_fields_set:
            _dict['invoice_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of PaymentIntentExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted") if obj.get("is_deleted") is not None else False,
            "amount_atom": obj.get("amount_atom"),
            "amount_atom_capturable": obj.get("amount_atom_capturable"),
            "amount_atom_received": obj.get("amount_atom_received"),
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "payment_method_id": obj.get("payment_method_id"),
            "status": obj.get("status"),
            "invoice_id": obj.get("invoice_id"),
            "charge_ids": obj.get("charge_ids"),
            "refund_ids": obj.get("refund_ids")
        })
        return _obj


