# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictStr
from pydantic import Field
from typing_extensions import Annotated
from getopenpay.models.billing_reason_enum import BillingReasonEnum
from getopenpay.models.date_time_filter import DateTimeFilter
from getopenpay.models.int_range_filter import IntRangeFilter
from getopenpay.models.invoice_status_enum import InvoiceStatusEnum
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class InvoiceQueryParams(BaseModel):
    """
    InvoiceQueryParams
    """ # noqa: E501
    page_number: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=1, description="Page number")
    page_size: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = Field(default=100, description="Page size")
    sort_key: Optional[StrictStr] = Field(default='created_at', description="Key name based on which data is sorted.")
    sort_descending: Optional[StrictBool] = Field(default=False, description="Sort direction.")
    created_at: Optional[DateTimeFilter] = None
    expand: Optional[List[StrictStr]] = None
    customer_id: Optional[StrictStr] = None
    status: Optional[InvoiceStatusEnum] = None
    subscription_id: Optional[StrictStr] = None
    billing_reason: Optional[BillingReasonEnum] = None
    total_amount_atom: Optional[IntRangeFilter] = None
    period_start: Optional[DateTimeFilter] = None
    period_end: Optional[DateTimeFilter] = None
    coupon_id: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["page_number", "page_size", "sort_key", "sort_descending", "created_at", "expand", "customer_id", "status", "subscription_id", "billing_reason", "total_amount_atom", "period_start", "period_end", "coupon_id"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of InvoiceQueryParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_at
        if self.created_at:
            _dict['created_at'] = self.created_at.to_dict()
        # override the default output from pydantic by calling `to_dict()` of total_amount_atom
        if self.total_amount_atom:
            _dict['total_amount_atom'] = self.total_amount_atom.to_dict()
        # override the default output from pydantic by calling `to_dict()` of period_start
        if self.period_start:
            _dict['period_start'] = self.period_start.to_dict()
        # override the default output from pydantic by calling `to_dict()` of period_end
        if self.period_end:
            _dict['period_end'] = self.period_end.to_dict()
        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if customer_id (nullable) is None
        # and model_fields_set contains the field
        if self.customer_id is None and "customer_id" in self.model_fields_set:
            _dict['customer_id'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if subscription_id (nullable) is None
        # and model_fields_set contains the field
        if self.subscription_id is None and "subscription_id" in self.model_fields_set:
            _dict['subscription_id'] = None

        # set to None if billing_reason (nullable) is None
        # and model_fields_set contains the field
        if self.billing_reason is None and "billing_reason" in self.model_fields_set:
            _dict['billing_reason'] = None

        # set to None if total_amount_atom (nullable) is None
        # and model_fields_set contains the field
        if self.total_amount_atom is None and "total_amount_atom" in self.model_fields_set:
            _dict['total_amount_atom'] = None

        # set to None if period_start (nullable) is None
        # and model_fields_set contains the field
        if self.period_start is None and "period_start" in self.model_fields_set:
            _dict['period_start'] = None

        # set to None if period_end (nullable) is None
        # and model_fields_set contains the field
        if self.period_end is None and "period_end" in self.model_fields_set:
            _dict['period_end'] = None

        # set to None if coupon_id (nullable) is None
        # and model_fields_set contains the field
        if self.coupon_id is None and "coupon_id" in self.model_fields_set:
            _dict['coupon_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of InvoiceQueryParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "page_number": obj.get("page_number") if obj.get("page_number") is not None else 1,
            "page_size": obj.get("page_size") if obj.get("page_size") is not None else 100,
            "sort_key": obj.get("sort_key") if obj.get("sort_key") is not None else 'created_at',
            "sort_descending": obj.get("sort_descending") if obj.get("sort_descending") is not None else False,
            "created_at": DateTimeFilter.from_dict(obj.get("created_at")) if obj.get("created_at") is not None else None,
            "expand": obj.get("expand"),
            "customer_id": obj.get("customer_id"),
            "status": obj.get("status"),
            "subscription_id": obj.get("subscription_id"),
            "billing_reason": obj.get("billing_reason"),
            "total_amount_atom": IntRangeFilter.from_dict(obj.get("total_amount_atom")) if obj.get("total_amount_atom") is not None else None,
            "period_start": DateTimeFilter.from_dict(obj.get("period_start")) if obj.get("period_start") is not None else None,
            "period_end": DateTimeFilter.from_dict(obj.get("period_end")) if obj.get("period_end") is not None else None,
            "coupon_id": obj.get("coupon_id")
        })
        return _obj


