# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.credit_card_type import CreditCardType
from getopenpay.models.invoice_item_public import InvoiceItemPublic
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class InvoicePublic(BaseModel):
    """
    InvoicePublic
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier of the invoice.")
    paid_at: datetime = Field(description="When the invoice is paid, in 'ISO 8601' format.")
    paid_amount_atom: StrictInt = Field(description="Total amount paid. It is in atomic units (in USD this is cents).")
    billed_to: Optional[StrictStr] = None
    billing_address: Optional[StrictStr] = None
    card_type: Optional[CreditCardType] = None
    last_four: Optional[StrictStr] = None
    lines: Optional[List[InvoiceItemPublic]] = None
    branding: Union[str, Any] = Field(description="The branding settings associated with the account")
    __properties: ClassVar[List[str]] = ["id", "paid_at", "paid_amount_atom", "billed_to", "billing_address", "card_type", "last_four", "lines", "branding"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of InvoicePublic from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in lines (list)
        _items = []
        if self.lines:
            for _item in self.lines:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lines'] = _items
        # set to None if billed_to (nullable) is None
        # and model_fields_set contains the field
        if self.billed_to is None and "billed_to" in self.model_fields_set:
            _dict['billed_to'] = None

        # set to None if billing_address (nullable) is None
        # and model_fields_set contains the field
        if self.billing_address is None and "billing_address" in self.model_fields_set:
            _dict['billing_address'] = None

        # set to None if card_type (nullable) is None
        # and model_fields_set contains the field
        if self.card_type is None and "card_type" in self.model_fields_set:
            _dict['card_type'] = None

        # set to None if last_four (nullable) is None
        # and model_fields_set contains the field
        if self.last_four is None and "last_four" in self.model_fields_set:
            _dict['last_four'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of InvoicePublic from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "paid_at": obj.get("paid_at"),
            "paid_amount_atom": obj.get("paid_amount_atom"),
            "billed_to": obj.get("billed_to"),
            "billing_address": obj.get("billing_address"),
            "card_type": obj.get("card_type"),
            "last_four": obj.get("last_four"),
            "lines": [InvoiceItemPublic.from_dict(_item) for _item in obj.get("lines")] if obj.get("lines") is not None else None,
            "branding": obj.get("branding")
        })
        return _obj


