# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.invoice_item_discount_amounts_public import InvoiceItemDiscountAmountsPublic
from getopenpay.models.price_tier_public import PriceTierPublic
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class InvoiceItemPublic(BaseModel):
    """
    InvoiceItemPublic
    """ # noqa: E501
    name: StrictStr = Field(description="The name of the line item as it appears in the invoice.")
    quantity: StrictInt = Field(description="Quantity of the line item.")
    amount_atom: StrictInt = Field(description="Total amount of invoice_item in atomic units (in USD this is cents).")
    currency: StrictStr
    invoice_item_description: Optional[StrictStr]
    discounts: List[StrictStr]
    discount_amount_atoms: List[InvoiceItemDiscountAmountsPublic]
    amount_atom_considering_discount_applied: StrictInt = Field(description="Total amount of invoice_item in atomic units considering discounts")
    price_tiers: Optional[List[PriceTierPublic]] = None
    __properties: ClassVar[List[str]] = ["name", "quantity", "amount_atom", "currency", "invoice_item_description", "discounts", "discount_amount_atoms", "amount_atom_considering_discount_applied", "price_tiers"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of InvoiceItemPublic from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in discount_amount_atoms (list)
        _items = []
        if self.discount_amount_atoms:
            for _item in self.discount_amount_atoms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['discount_amount_atoms'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in price_tiers (list)
        _items = []
        if self.price_tiers:
            for _item in self.price_tiers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['price_tiers'] = _items
        # set to None if invoice_item_description (nullable) is None
        # and model_fields_set contains the field
        if self.invoice_item_description is None and "invoice_item_description" in self.model_fields_set:
            _dict['invoice_item_description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of InvoiceItemPublic from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "quantity": obj.get("quantity"),
            "amount_atom": obj.get("amount_atom"),
            "currency": obj.get("currency"),
            "invoice_item_description": obj.get("invoice_item_description"),
            "discounts": obj.get("discounts"),
            "discount_amount_atoms": [InvoiceItemDiscountAmountsPublic.from_dict(_item) for _item in obj.get("discount_amount_atoms")] if obj.get("discount_amount_atoms") is not None else None,
            "amount_atom_considering_discount_applied": obj.get("amount_atom_considering_discount_applied"),
            "price_tiers": [PriceTierPublic.from_dict(_item) for _item in obj.get("price_tiers")] if obj.get("price_tiers") is not None else None
        })
        return _obj


